/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejb.queueCMTTests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.commonee.Tests;
import jakarta.ejb.EJB;
import jakarta.jms.Queue;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejb.queueCMTTests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    @EJB(name="ejb/QueueTests")
    private static Tests beanRef;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            if (beanRef == null) {
                throw new Exception("@EJB injection failed");
            }
            this.props = p;
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            beanRef.initLogging(this.props);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
    }

    private void flushTheQueue() throws Exception {
        JmsTool tool = null;
        try {
            tool = new JmsTool(0, this.user, this.password, this.mode);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error creating JmsTool and closing Connection", (Throwable)e);
        }
        finally {
            try {
                tool.flushQueue();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error flush : ", (Throwable)e);
            }
            try {
                TestUtil.logTrace((String)"Closing default QueueConnection");
                tool.getDefaultQueueConnection().close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error clsoing connection : ", (Throwable)e);
            }
        }
    }

    public void bytesMessageFullMsgTests() throws Exception {
        try {
            beanRef.sendFullBytesMessage_Q(testName);
            if (!beanRef.verifyFullBytesMessage()) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test bytesMessageFullMsgTests: ", e);
            throw new Exception("bytesMessageFullMsgTests", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void mapMessageFullMsgTest() throws Exception {
        try {
            beanRef.sendFullMapMessage_Q(testName);
            if (!beanRef.verifyFullMapMessage()) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test mapMessageFullMsgTest: ", e);
            throw new Exception("mapMessageFullMsgTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void streamMessageFullMsgTest() throws Exception {
        try {
            beanRef.sendFullStreamMessage_Q(testName);
            if (!beanRef.verifyFullStreamMessage()) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test streamMessageFullMsgTest: ", e);
            throw new Exception("streamMessageFullMsgTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrIDTest() throws Exception {
        String id = null;
        boolean pass = true;
        try {
            beanRef.sendTextMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                TestUtil.logErr((String)("TextMessage: JMSMessageID does not start with ID:" + id));
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                TestUtil.logErr((String)("BytesMessage: JMSMessageID does not start with ID:" + id));
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                TestUtil.logErr((String)("MapMessage: JMSMessageID does not start with ID:" + id));
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                TestUtil.logErr((String)("StreamMessage: JMSMessageID does not start with ID:" + id));
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                TestUtil.logErr((String)("ObjectMessage: JMSMessageID does not start with ID:" + id));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrIDTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrIDTest: ", e);
            throw new Exception("msgHdrIDTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    private boolean chkMessageID(String id) {
        boolean retcode = true;
        boolean index = false;
        if (id != null && !id.startsWith("ID:")) {
            retcode = false;
        }
        return retcode;
    }

    public void msgHdrTimeStampTest() throws Exception {
        ArrayList sendValue = null;
        boolean pass = true;
        try {
            sendValue = beanRef.sendTextMessage_Q(testName);
            long JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                TestUtil.logErr((String)("TextMessage: JMSMessageTimestamp return wrong value:" + JMSTimestamp));
                TestUtil.logErr((String)("should be between time before send " + String.valueOf(sendValue.get(0)) + " and time after send " + String.valueOf(sendValue.get(1))));
                pass = false;
            }
            sendValue = beanRef.sendFullBytesMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                TestUtil.logErr((String)("BytesMessage: JMSMessageTimestamp return wrong value:" + JMSTimestamp));
                TestUtil.logErr((String)("should be between time before send " + String.valueOf(sendValue.get(0)) + " and time after send " + String.valueOf(sendValue.get(1))));
                pass = false;
            }
            sendValue = beanRef.sendFullMapMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                TestUtil.logErr((String)("MapMessage: JMSMessageTimestamp return wrong value:" + JMSTimestamp));
                TestUtil.logErr((String)("should be between time before send " + String.valueOf(sendValue.get(0)) + " and time after send " + String.valueOf(sendValue.get(1))));
                pass = false;
            }
            sendValue = beanRef.sendFullStreamMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                TestUtil.logErr((String)("StreamMessage: JMSMessageTimestamp return wrong value: " + JMSTimestamp));
                TestUtil.logErr((String)("should be between time before send " + String.valueOf(sendValue.get(0)) + " and time after send " + String.valueOf(sendValue.get(1))));
                pass = false;
            }
            sendValue = beanRef.sendObjectMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                TestUtil.logErr((String)("ObjectMessage: JMSMessageTimestamp return wrong value: " + JMSTimestamp));
                TestUtil.logErr((String)("should be between time before send " + String.valueOf(sendValue.get(0)) + " and time after send " + String.valueOf(sendValue.get(1))));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrTimeStampTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrTimeStampTest: ", e);
            throw new Exception("msgHdrTimeStampTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrCorlIdTest() throws Exception {
        boolean pass = true;
        String jmsCorrelationID = "JMSTCKCorrelationID";
        try {
            beanRef.sendTextMessage_Q(testName);
            String tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                TestUtil.logErr((String)("TextMessage: incorrect JMSCorrelationID returned: " + tmp));
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                TestUtil.logErr((String)("BytesMessage: incorrect JMSCorrelationID returned: " + tmp));
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                TestUtil.logErr((String)("MapMessage: incorrect JMSCorrelationID returned:" + tmp));
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                TestUtil.logErr((String)("StreamMessage: incorrect JMSCorrelationID returned:" + tmp));
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                TestUtil.logErr((String)("ObjectMessage: incorrect JMSCorrelationID returned:" + tmp));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrCorlIdTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrCorlIdTest: ", e);
            throw new Exception("msgHdrCorlIdTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrReplyToTest() throws Exception {
        boolean pass = true;
        String QueueName = null;
        String QueueName_used = null;
        try {
            beanRef.sendTextMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                TestUtil.logErr((String)"TextMessage: null JMSReplyTo should be returned");
                pass = false;
            }
            beanRef.sendTextMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            QueueName_used = beanRef.getDestination_1();
            if (!QueueName.equals(QueueName_used)) {
                TestUtil.logErr((String)("TextMessage: incorrect JMSReplyTo returned: " + QueueName));
                TestUtil.logErr((String)("TextMessage: expecting: " + QueueName_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"TextMessage: passed");
            }
            beanRef.sendFullBytesMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                TestUtil.logErr((String)"BytesMessage: null JMSReplyTo should be returned");
                pass = false;
            }
            beanRef.sendBytesMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                TestUtil.logErr((String)("BytesMessage: incorrect JMSReplyTo returned:" + QueueName));
                TestUtil.logErr((String)("BytesMessage: expecting: " + QueueName_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"BytesMessage: passed");
            }
            beanRef.sendFullMapMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                TestUtil.logErr((String)("MapMessage: null JMSReplyTo should be returned:" + QueueName));
                pass = false;
            }
            beanRef.sendMapMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                TestUtil.logErr((String)("MapMessage: incorrect JMSReplyTo returned: " + QueueName));
                TestUtil.logErr((String)("MapMessage: expecting: " + QueueName_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"MapMessage: passed");
            }
            beanRef.sendFullStreamMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                TestUtil.logErr((String)("StreamMessage: null JMSReplyTo should be returned: " + QueueName));
                pass = false;
            }
            beanRef.sendStreamMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                TestUtil.logErr((String)("StreamMessage: incorrect JMSReplyTo returned: " + QueueName));
                TestUtil.logErr((String)("StreamMessage: expecting: " + QueueName_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"StreamMessage: passed");
            }
            beanRef.sendObjectMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                TestUtil.logErr((String)("ObjectMessage: null JMSReplyTo should be returned" + QueueName));
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                TestUtil.logErr((String)("ObjectMessage: incorrect JMSReplyTo returned: " + QueueName));
                TestUtil.logErr((String)("ObjectMessage: expecting: " + QueueName_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"ObjectMessage: passed");
            }
            if (!pass) {
                throw new Exception("msgHdrReplyToTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrReplyToTest: ", e);
            throw new Exception("msgHdrReplyToTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrJMSTypeTest() throws Exception {
        boolean pass = true;
        String type = "JMSTCKTESTMSG";
        try {
            beanRef.sendTextMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                TestUtil.logErr((String)("TextMessage: wrong JMSType returned: " + beanRef.getType()));
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                TestUtil.logErr((String)"BytesMessage: wrong JMSType returned");
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                TestUtil.logErr((String)"MapMessage: wrong JMSType returned");
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                TestUtil.logErr((String)("StreamMessage: wrong JMSType returned" + beanRef.getType()));
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                TestUtil.logErr((String)("ObjectMessage: wrong JMSType returned" + beanRef.getType()));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSTypeTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrJMSTypeTest: ", e);
            throw new Exception("msgHdrJMSTypeTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrJMSPriorityTest() throws Exception {
        boolean pass = true;
        int priority = 2;
        try {
            beanRef.sendTextMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                TestUtil.logErr((String)("TextMessage: wrong JMSPriority returned: " + beanRef.getPriority()));
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                TestUtil.logErr((String)("BytesMessage: wrong JMSPriority returned: " + beanRef.getPriority()));
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                TestUtil.logErr((String)("MapMessage: wrong JMSPriority returned: " + beanRef.getPriority()));
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                TestUtil.logErr((String)("StreamMessage: wrong JMSPriority returned: " + beanRef.getPriority()));
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                TestUtil.logErr((String)("ObjectMessage: wrong JMSPriority returned: " + beanRef.getPriority()));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSPriorityTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrJMSPriorityTest: ", e);
            throw new Exception("msgHdrJMSPriorityTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrJMSExpirationTest() throws Exception {
        boolean pass = true;
        long forever = 0L;
        try {
            beanRef.sendTextMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                TestUtil.logErr((String)("TextMessage: wrong JMSExpiration returned: " + beanRef.getExpiration()));
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                TestUtil.logErr((String)("BytesMessage: wrong JMSExpiration returned: " + beanRef.getExpiration()));
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                TestUtil.logErr((String)("MapMessage: wrong JMSExpiration returned: " + beanRef.getExpiration()));
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                TestUtil.logErr((String)("StreamMessage: wrong JMSExpiration returned: " + beanRef.getExpiration()));
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                TestUtil.logErr((String)("ObjectMessage: wrong JMSExpiration returned: " + beanRef.getExpiration()));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSExpirationTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrJMSExpirationTest: ", e);
            throw new Exception("msgHdrJMSExpirationTest");
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrJMSDestinationTest() throws Exception {
        boolean pass = true;
        long forever = 0L;
        String dest = null;
        String dest_used = null;
        try {
            beanRef.sendTextMessage_Q(testName);
            dest = beanRef.getDestination();
            dest_used = beanRef.getDestination_1();
            if (!dest.equals(dest_used)) {
                TestUtil.logErr((String)("TextMessage: wrong JMSDestination returned: " + dest));
                TestUtil.logErr((String)("Expecting " + dest_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"TextMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                TestUtil.logErr((String)("BytesMessage: wrong JMSDestination returned: " + dest));
                TestUtil.logErr((String)("Expecting " + dest_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"BytesMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                TestUtil.logErr((String)("MapMessage: wrong JMSDestination returned: " + dest));
                TestUtil.logErr((String)("Expecting " + dest_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"MapMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                TestUtil.logErr((String)("StreamMessage: wrong JMSDestination returned: " + dest));
                TestUtil.logErr((String)("Expecting " + dest_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"StreamMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendObjectMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                TestUtil.logErr((String)("ObjectMessage: wrong JMSDestination returned: " + dest));
                TestUtil.logErr((String)("Expecting " + dest_used));
                pass = false;
            } else {
                TestUtil.logTrace((String)"ObjectMessage: msgHdrJMSDestinationTest passed.");
            }
            if (!pass) {
                throw new Exception("msgHdrJMSDestinationTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrJMSDestinationTest: ", e);
            throw new Exception("msgHdrJMSDestinationTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void msgHdrJMSDeliveryModeTest() throws Exception {
        boolean pass = true;
        long forever = 0L;
        try {
            beanRef.sendTextMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                TestUtil.logErr((String)("TextMessage: wrong DeliveryMode returned: " + beanRef.getDeliveryMode()));
                pass = false;
            }
            beanRef.sendTextMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                TestUtil.logErr((String)("TextMessage: wrong DeliveryMode returned: " + beanRef.getDeliveryMode()));
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                TestUtil.logErr((String)"BytesMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendBytesMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                TestUtil.logErr((String)"BytesMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                TestUtil.logErr((String)"MapMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendMapMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                TestUtil.logErr((String)"MapMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                TestUtil.logErr((String)"StreamMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendStreamMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                TestUtil.logErr((String)"StreamMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                TestUtil.logErr((String)"ObjectMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                TestUtil.logErr((String)"ObjectMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSDeliveryModeTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test msgHdrJMSDeliveryModeTest: ", e);
            throw new Exception("msgHdrJMSDeliveryModeTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void messageOrderTest() throws Exception {
        int numMessages = 3;
        String[] text = new String[numMessages];
        try {
            int i;
            for (i = 0; i < numMessages; ++i) {
                text[i] = "message order test " + i;
                beanRef.sendTextMessage_Q(testName + i, text[i]);
            }
            for (i = 0; i < numMessages; ++i) {
                if (beanRef.getText().equals(text[i])) continue;
                this.logErr("Received message: ");
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test messageOrderTest: ", e);
            throw new Exception("messageOrderTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    public void nullDestinationTest() throws Exception {
        String text = "JMS TCK test for null Destination";
        Queue testQueue = null;
        try {
            beanRef.sendTextMessage_Q(testName, text, testQueue);
            if (!beanRef.getText().equals(text)) {
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            this.logErr("Caught Exception in test nullDestinationTest: ", e);
            throw new Exception("nullDestinationTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }
}

