/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.queuetests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.DoneLatch;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.SerialTestMessageListenerImpl;
import com.sun.ts.tests.jms.common.SessionThread;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import jakarta.jms.TopicConnection;
import java.util.ArrayList;
import java.util.Properties;

public class QueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.queuetests.QueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    ArrayList queues = null;
    ArrayList connections = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;

    public static void main(String[] args) {
        QueueTests theTests = new QueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null ");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(10);
            this.connections = new ArrayList(5);
            TestUtil.logMsg((String)"adding the default queue to the queue cleaner lsit\n");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void receiveNullClosedSessionQueueTest() throws Exception {
        int waitTime = 15;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.logMsg("Close default QueueReceiver");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            this.logMsg("Create QueueRequestor");
            QueueRequestor qReq = new QueueRequestor(this.tool.getDefaultQueueSession(), this.tool.getDefaultQueue());
            this.logMsg("Create SessionThread");
            SessionThread sT = new SessionThread(this.tool.getDefaultQueueConnection(), (TopicConnection)null);
            this.logMsg("Tell SessionThread to respond to messages");
            sT.setReplyToMessages(true);
            this.logMsg("Create Receiver in SessionThread");
            sT.createConsumer((Destination)this.tool.getDefaultQueue());
            this.logMsg("Tell receiver to keep receiving\n(it will throw an exception and stop when it receives the null message)");
            sT.setStayAlive(true);
            this.logMsg("Start the SessionThread");
            sT.start();
            this.logMsg("Send one message and receive reply");
            Message tempMsg = this.tool.getDefaultQueueSession().createMessage();
            tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "receiveNullClosedSessionQueueTest");
            qReq.request(tempMsg);
            this.logMsg("Wait " + waitTime + " seconds for receive() to start again before closing session...");
            for (int i = 0; i < 100000; ++i) {
            }
            this.logMsg("Close the SessionThread's QueueSession");
            sT.getQueueSession().close();
            this.logMsg("Wait for thread to close (will close after receiving null message)");
            sT.join();
            if (sT.isAlive()) {
                this.logErr("thread still waiting on receive() -- BAD [could be timing problem]");
                throw new Exception("receive() call still waiting");
            }
            this.logMsg("receive() properly received a null message -- GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("receiveNullClosedSessionQueueTest");
        }
    }

    public void setClientIDLateQueueTest() throws Exception {
        boolean booleanValue = true;
        boolean pass = true;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            QueueConnection qConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(qConn);
            QueueSession qSess = qConn.createQueueSession(false, 1);
            Queue queue = this.tool.createNewQueue("testQueue2");
            this.queues.add(queue);
            QueueSender qSender = qSess.createSender(queue);
            QueueReceiver qRec = qSess.createReceiver(queue);
            qConn.start();
            this.logTrace("Creating 1 message");
            MapMessage messageSent = qSess.createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateQueueTest");
            messageSent.setBoolean("booleanValue", booleanValue);
            this.logTrace("Sending message");
            qSender.send((Message)messageSent);
            this.logTrace("Receiving message");
            MapMessage messageReceived = (MapMessage)qRec.receive(this.timeout);
            messageReceived.getBoolean("booleanValue");
            this.logTrace("Attempt to set Client ID too late");
            try {
                qConn.setClientID("setClientIDLateQueueTest");
                pass = false;
                this.logMsg("Error: Illegal state exception was not thrown");
            }
            catch (IllegalStateException is) {
                this.logTrace("Pass: IllegalStateException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setClientIDLateQueueTest");
        }
    }

    public void autoAckMsgListenerQueueTest() throws Exception {
        try {
            Message messageSent = null;
            AutoAckMsgListener mListener = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.logTrace("Create and set MessageListener.");
            mListener = new AutoAckMsgListener(new DoneLatch(), this.tool.getDefaultQueueSession());
            this.tool.getDefaultQueueReceiver().setMessageListener((MessageListener)mListener);
            this.logTrace("Send and receive two messages");
            messageSent = this.tool.getDefaultQueueSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "autoAckMsgListenerQueueTest");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(messageSent);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("waiting until message has been received by message listener...");
            mListener.monitor.waitTillDone();
            if (!mListener.getPassed()) {
                throw new Exception("failed");
            }
        }
        catch (Exception e) {
            this.logMsg("Error: " + String.valueOf(e));
            throw new Exception("autoAckMsgListenerQueueTest", e);
        }
    }

    public void serialMsgListenerQueueTest() throws Exception {
        try {
            TextMessage[] tMsg = new TextMessage[3];
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            Queue newQ = this.tool.createNewQueue("testQueue2");
            this.queues.add(newQ);
            QueueReceiver qRec1 = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            QueueReceiver qRec2 = this.tool.getDefaultQueueSession().createReceiver(newQ);
            this.logMsg("Create two message listeners");
            SerialTestMessageListenerImpl myListener1 = new SerialTestMessageListenerImpl();
            SerialTestMessageListenerImpl myListener2 = new SerialTestMessageListenerImpl();
            qRec1.setMessageListener((MessageListener)myListener1);
            qRec2.setMessageListener((MessageListener)myListener2);
            QueueSender qSender1 = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
            QueueSender qSender2 = this.tool.getDefaultQueueSession().createSender(newQ);
            for (int i = 0; i < 3; ++i) {
                this.logMsg("Create and send message " + i);
                tMsg[i] = this.tool.getDefaultQueueSession().createTextMessage();
                tMsg[i].setText("serialMsgListenerQueueTest" + i);
                tMsg[i].setStringProperty("COM_SUN_JMS_TESTNAME", "serialMsgListenerQueueTest" + i);
                if (i == 2) {
                    tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", true);
                    qSender1.send((Message)tMsg[i]);
                    qSender2.send((Message)tMsg[i]);
                    continue;
                }
                tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", false);
                if (i % 2 == 0) {
                    qSender1.send((Message)tMsg[i]);
                    continue;
                }
                qSender2.send((Message)tMsg[i]);
            }
            this.logMsg("Start connection");
            this.tool.getDefaultQueueConnection().start();
            myListener1.monitor.waitTillDone();
            myListener2.monitor.waitTillDone();
            if (myListener1.testFailed || myListener2.testFailed) {
                this.logMsg("Test failed in message listener");
                throw new Exception("Concurrent use of MessageListener or JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("serialMsgListenerQueueTest");
        }
    }

    public void setGetChangeClientIDQueueTest() throws Exception {
        boolean pass = true;
        QueueConnection qc2 = null;
        try {
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            QueueConnection qc = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(qc);
            qc2 = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(qc2);
            TestUtil.logMsg((String)"Setting clientID!");
            qc.setClientID("ctstest");
            TestUtil.logMsg((String)"Getting clientID!");
            String clientid = qc.getClientID();
            if (!clientid.equals("ctstest")) {
                TestUtil.logErr((String)("getClientID() returned " + clientid + ", expected ctstest"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"setClientID/getClientID correct");
            }
            TestUtil.logMsg((String)"Resetting clientID! (excpect IllegalStateException)");
            qc.setClientID("changeIt");
            TestUtil.logErr((String)"Failed: No exception on ClientID reset");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e.getMessage()));
            pass = false;
        }
        catch (IllegalStateException ee) {
            TestUtil.logMsg((String)("Expected Exception received: " + ee.getMessage()));
        }
        catch (Exception eee) {
            TestUtil.logErr((String)("Incorrect exception received: " + eee.getMessage()));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Set clientID on second connection to value of clientID on first connection");
            TestUtil.logMsg((String)"Expect InvalidClientIDException");
            qc2.setClientID("ctstest");
            TestUtil.logErr((String)"Failed: No exception on ClientID when one already exists");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            TestUtil.logMsg((String)("Expected exception received: " + e.getMessage()));
        }
        catch (Exception eee) {
            TestUtil.logErr((String)("Incorrect exception received: " + eee.getMessage()));
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetChangeClientIDQueueTest");
        }
    }

    public void setGetExceptionListenerTest() throws Exception {
        boolean pass = true;
        Object qc = null;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for QUEUE");
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            TestUtil.logMsg((String)"Create ExceptionListener");
            ExceptionListener foo = new ExceptionListener(){

                public void onException(JMSException e) {
                }
            };
            TestUtil.logMsg((String)"Call setExceptionListener on Connection object");
            this.tool.getDefaultQueueConnection().setExceptionListener(foo);
            ExceptionListener foo2 = this.tool.getDefaultQueueConnection().getExceptionListener();
            if (!foo2.equals((Object)foo)) {
                TestUtil.logErr((String)"getExceptionListener doesn't match setExceptionListener");
                pass = false;
            }
        }
        catch (Exception eee) {
            TestUtil.logErr((String)("Unexpected exception received: " + eee.getMessage()));
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetExceptionListenerTest");
        }
    }

    public void reverseReceiveClientAckTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            int i2;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            Queue[] q = new Queue[3];
            QueueSender[] qSender = new QueueSender[3];
            QueueReceiver[] qReceiver = new QueueReceiver[3];
            Message[] msg = new Message[3];
            for (i2 = 0; i2 < 3; ++i2) {
                TestUtil.logMsg((String)("Creating Queue " + i2 + " of 2 (3 total)"));
                q[i2] = this.tool.createNewQueue("testQ" + i2);
                this.queues.add(q[i2]);
            }
            TestUtil.logMsg((String)"Creating 3 senders");
            for (i2 = 0; i2 < 3; ++i2) {
                TestUtil.logMsg((String)("sender " + i2));
                qSender[i2] = this.tool.getDefaultQueueSession().createSender(q[i2]);
            }
            TestUtil.logMsg((String)"Creating CLIENT_ACKNOWLEDGE session for receiving");
            QueueSession receiveSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            TestUtil.logMsg((String)"Creating 3 receivers in receive session");
            for (int i3 = 0; i3 < 3; ++i3) {
                TestUtil.logMsg((String)("receiver " + i3));
                qReceiver[i3] = receiveSession.createReceiver(q[i3]);
            }
            this.tool.getDefaultQueueConnection().start();
            Message tempMsg = null;
            for (i = 0; i < 3; ++i) {
                TestUtil.logMsg((String)("Sending message " + i));
                tempMsg = this.tool.getDefaultQueueSession().createMessage();
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "reverseReceiveClientAckTest");
                qSender[i].send(tempMsg);
            }
            TestUtil.logMsg((String)"Receive messages 0-2 in reverse order");
            for (i = 2; i >= 0; --i) {
                TestUtil.logMsg((String)("Receive message " + i));
                msg[i] = qReceiver[i].receive(this.timeout);
                if (msg[i] == null) {
                    TestUtil.logErr((String)("Did not receive message from receiver[" + i + "]"));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("msg = " + String.valueOf(msg[i])));
                    TestUtil.logMsg((String)("Acknowledge message " + i));
                    msg[i].acknowledge();
                }
                if (i != 2) continue;
                TestUtil.logMsg((String)"session.recover()");
                receiveSession.recover();
            }
            TestUtil.logMsg((String)"Try receiving message from all receivers again (should not receive any)");
            for (i = 2; i >= 0; --i) {
                msg[i] = qReceiver[i].receive(this.timeout);
                if (msg[i] == null) continue;
                TestUtil.logErr((String)("Received message from receiver[" + i + "], expected none"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("reverseReceiveClientAckTest");
        }
        finally {
            try {
                TestUtil.logMsg((String)"Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"An error occurred while cleaning", (Throwable)e);
                throw new Exception("Cleanup failed!", e);
            }
        }
        if (!pass) {
            throw new Exception("reverseReceiveClientAckTest");
        }
    }

    public void clientAckQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage sent1 = null;
            TextMessage sent2 = null;
            TextMessage sent3 = null;
            TextMessage sent4 = null;
            TextMessage rec2 = null;
            TextMessage rec4 = null;
            QueueSession qSess = null;
            QueueReceiver qRec = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            TestUtil.logMsg((String)"Start connection");
            this.tool.getDefaultQueueConnection().start();
            sent1 = qSess.createTextMessage();
            sent1.setText("test message 1");
            sent1.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest1");
            sent2 = qSess.createTextMessage();
            sent2.setText("test message 2");
            sent2.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest2");
            sent3 = qSess.createTextMessage();
            sent3.setText("test message 3");
            sent3.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest3");
            sent4 = qSess.createTextMessage();
            sent4.setText("test message 4");
            sent4.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckQueueTest4");
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            qSender = qSess.createSender(this.tool.getDefaultQueue());
            TestUtil.logTrace((String)"Send three messages");
            qSender.send((Message)sent1);
            qSender.send((Message)sent2);
            qSender.send((Message)sent3);
            TestUtil.logTrace((String)"Receive three messages");
            qRec.receive(this.timeout);
            TestUtil.logTrace((String)"Received the first message");
            rec2 = (TextMessage)qRec.receive(this.timeout);
            TestUtil.logTrace((String)"Received the second message");
            qRec.receive(this.timeout);
            TestUtil.logTrace((String)"Received the third message");
            TestUtil.logTrace((String)"Acknowledging the second message");
            rec2.acknowledge();
            TestUtil.logTrace((String)"Send the fourth message");
            qSender.send((Message)sent4);
            TestUtil.logTrace((String)"Receive the fourth message");
            rec4 = (TextMessage)qRec.receive(this.timeout);
            TestUtil.logTrace((String)"Received the fourth message");
            TestUtil.logTrace((String)"Call session.recover()");
            qSess.recover();
            TestUtil.logTrace((String)"Attempt to receive unacked message - the fourth message again");
            rec4 = (TextMessage)qRec.receive(this.timeout);
            if (rec4 == null) {
                pass = false;
                TestUtil.logErr((String)"Did not receive unacked message");
            } else {
                if (!rec4.getText().equals(sent4.getText())) {
                    pass = false;
                    TestUtil.logErr((String)("Received wrong message: " + rec4.getText()));
                } else {
                    TestUtil.logMsg((String)("Re-received message: " + rec4.getText()));
                }
                TestUtil.logTrace((String)"Acknowledge the received message");
                rec4.acknowledge();
            }
            if (!pass) {
                throw new Exception("clientAckQueueTest Failed!!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: ", (Throwable)e);
            throw new Exception("clientAckQueueTest", e);
        }
        finally {
            try {
                TestUtil.logMsg((String)"Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"An error occurred while cleaning", (Throwable)e);
                throw new Exception("Cleanup failed!", e);
            }
        }
    }

    public void nonAckMsgsRedeliveredQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg;
            int i;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            TestUtil.logTrace((String)"Close QueueReceiver in default session -- only want one for Queue");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            QueueSession qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            QueueReceiver qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            QueueSender qSender = qSession.createSender(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            for (i = 0; i < 3; ++i) {
                tempMsg = qSession.createTextMessage();
                tempMsg.setText("test message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "nonAckMsgsRedeliveredQueueTest" + i);
                qSender.send((Message)tempMsg);
                TestUtil.logTrace((String)("sent message " + i));
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)qReceiver.receive(this.timeout);
                if (tempMsg == null) {
                    pass = false;
                    TestUtil.logErr((String)("Did not receive message " + i));
                    continue;
                }
                TestUtil.logTrace((String)("received message " + i));
            }
            qSender.close();
            qReceiver.close();
            qSession.close();
            qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)qReceiver.receive(this.timeout);
                if (tempMsg == null) {
                    pass = false;
                    TestUtil.logErr((String)("Did not receive message " + i));
                    continue;
                }
                TestUtil.logTrace((String)("received message \"" + tempMsg.getText() + "\" second time"));
            }
            if (!pass) {
                throw new Exception("nonAckMsgsRedeliveredQueueTest failed!!!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"nonAckMsgsRedeliveredQueueTest failed: ", (Throwable)e);
            throw new Exception("nonAckMsgsRedeliveredQueueTest failed", e);
        }
        finally {
            try {
                TestUtil.logMsg((String)"Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"An error occurred while cleaning", (Throwable)e);
                throw new Exception("Cleanup failed!", e);
            }
        }
    }

    public void queueRequestorSimpleSendAndRecvTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueRequestor qreq = null;
            TestUtil.logMsg((String)"Set up JmsTool for QUEUE");
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("This is the request message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "queueRequestorSimpleSendAndRecvTest");
            TestUtil.logMsg((String)"Set up MessageListener");
            this.tool.getDefaultQueueReceiver().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultQueueSession()));
            TestUtil.logMsg((String)"Set up QueueRequestor for request/response message exchange");
            QueueSession newqs = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qreq = new QueueRequestor(newqs, this.tool.getDefaultQueue());
            TestUtil.logMsg((String)"Send message request and receive message response using QueueRequestor");
            TestUtil.logMsg((String)("Message request text: \"" + messageSent.getText() + "\""));
            messageReceived = (TextMessage)qreq.request((Message)messageSent);
            TestUtil.logMsg((String)("Message response text: \"" + messageReceived.getText() + "\""));
            if (messageReceived.getText().equals("This is the response message")) {
                TestUtil.logMsg((String)"Received correct response message");
            } else {
                TestUtil.logErr((String)"Received incorrect response message");
                pass = false;
            }
            TestUtil.logMsg((String)"Close QueueRequestor");
            qreq.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueRequestorSimpleSendAndRecvTest failed");
        }
        if (!pass) {
            throw new Exception("queueRequestorSimpleSendAndRecvTest failed");
        }
    }

    public void queueRequestorExceptionTests() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Queue invalidDest = null;
            QueueRequestor qreq = null;
            TestUtil.logMsg((String)"Set up JmsTool for QUEUE");
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Set up MessageListener");
            this.tool.getDefaultQueueReceiver().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultQueueSession()));
            QueueSession newqs = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            try {
                TestUtil.logMsg((String)"Set up QueueRequestor with InvalidDestination");
                qreq = new QueueRequestor(newqs, invalidDest);
                TestUtil.logErr((String)"Didn't throw InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
            }
            try {
                TestUtil.logMsg((String)"Set up QueueRequestor with a closed QueueSession");
                newqs.close();
                qreq = new QueueRequestor(newqs, this.tool.getDefaultQueue());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            this.tool.closeAllConnections(this.connections);
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Set up QueueRequestor");
            qreq = new QueueRequestor(this.tool.getDefaultQueueSession(), this.tool.getDefaultQueue());
            TestUtil.logMsg((String)"Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "queueRequestorExceptionTests");
            TestUtil.logMsg((String)"Close QueueRequestor");
            qreq.close();
            TestUtil.logMsg((String)"Try a request/response message exchange on a closed QueueRequestor");
            try {
                messageReceived = (TextMessage)qreq.request((Message)messageSent);
                if (messageReceived != null) {
                    TestUtil.logMsg((String)("messageReceived=" + messageReceived.getText()));
                }
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
                qreq.close();
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueRequestorExceptionTests failed");
        }
        if (!pass) {
            throw new Exception("queueRequestorExceptionTests failed");
        }
    }

    public static class AutoAckMsgListener
    implements MessageListener {
        private boolean passed;
        QueueSession session;
        final DoneLatch monitor;

        public AutoAckMsgListener(DoneLatch latch, QueueSession qSession) {
            this.monitor = latch;
            this.session = qSession;
        }

        public boolean getPassed() {
            return this.passed;
        }

        public void onMessage(Message message) {
            try {
                if (!message.getBooleanProperty("lastMessage")) {
                    TestUtil.logTrace((String)"Received first message.");
                    if (message.getJMSRedelivered()) {
                        TestUtil.logMsg((String)"Error: received first message twice");
                        this.passed = false;
                    }
                } else if (!message.getJMSRedelivered()) {
                    TestUtil.logTrace((String)"Received second message. Calling recover()");
                    this.session.recover();
                } else {
                    TestUtil.logTrace((String)"Received second message again as expected");
                    this.passed = true;
                    this.monitor.allDone();
                }
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)("Exception caught in message listener:\n" + String.valueOf((Object)e)));
                this.passed = false;
                this.monitor.allDone();
            }
        }
    }

    public static class RequestorMsgListener
    implements MessageListener {
        QueueSession session = null;
        boolean pass = false;

        public RequestorMsgListener(QueueSession session) {
            this.session = session;
        }

        public boolean getPass() {
            return this.pass;
        }

        public void onMessage(Message message) {
            try {
                TestUtil.logMsg((String)"RequestorMsgListener.onMessage()");
                if (message instanceof TextMessage) {
                    TextMessage tmsg = (TextMessage)message;
                    TestUtil.logMsg((String)("Request message=" + tmsg.getText()));
                    if (tmsg.getText().equals("This is the request message")) {
                        TestUtil.logMsg((String)"Received request message is correct");
                        this.pass = true;
                    } else {
                        TestUtil.logErr((String)"Received request message is incorrect");
                        this.pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Received request message is not a TextMessage");
                    this.pass = false;
                }
                Queue replyQ = (Queue)message.getJMSReplyTo();
                QueueSender sender = this.session.createSender(replyQ);
                TextMessage responseMsg = this.session.createTextMessage();
                responseMsg.setText("This is the response message");
                responseMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "RequestorMsgListenerResponseMsg");
                TestUtil.logMsg((String)"Sending back response message");
                sender.send((Message)responseMsg);
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)("Exception caught in RequestorMsgListener:\n" + String.valueOf((Object)e)));
            }
        }
    }
}

