/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.lock.entitymanager;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.lock.entitymanager.Coffee;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockOption;
import jakarta.persistence.Timeout;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.logTrace("Cleanup data");
            this.removeTestData();
            this.logTrace("Create Test data");
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void findTest1() throws Exception {
        this.logTrace("Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            if (coffeeFound != null) {
                this.logTrace("Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("findTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest2() throws Exception {
        this.logTrace("Begin findTest2");
        boolean pass = false;
        this.getEntityTransaction().begin();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ, myMap);
            if (coffeeFound != null) {
                this.logTrace("Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("findTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest3() throws Exception {
        this.logTrace("Begin findTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            this.logTrace("locate Entity Coffee in EntityManager em2 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("findTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest4() throws Exception {
        this.logTrace("Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, myMap);
            if (coffeeFound != null) {
                this.logTrace("Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("findTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTest1() throws Exception {
        this.logTrace("Begin lockTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE);
            this.logTrace("locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("lockTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTest2() throws Exception {
        this.logTrace("Begin lockTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE, myMap);
            this.logTrace("locate Entity Coffee in EntityManager em1 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("lockTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTest3() throws Exception {
        this.logTrace("Begin lockTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            LockOption[] lockOptions = new LockOption[]{Timeout.ms((int)0)};
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE, lockOptions);
            this.logTrace("locate Entity Coffee in EntityManager em1 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("lockTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTest1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().refresh((Object)coffeeFound, LockModeType.PESSIMISTIC_READ);
            this.logTrace("locate Entity Coffee in EntityManager  and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().refresh((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("refreshTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTest2() throws Exception {
        this.logTrace("Begin refreshTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().refresh((Object)coffeeFound, LockModeType.PESSIMISTIC_READ, myMap);
            this.logTrace("locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            this.getEntityManager().refresh((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("refreshTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTest3() throws Exception {
        this.logTrace("Begin refreshTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("locate Entity Coffee in EntityManager");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().refresh((Object)coffeeFound, myMap);
            this.logTrace("locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            this.getEntityManager().refresh((Object)coffeeFound2, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("refreshTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            this.logTrace("Create 5 Coffees");
            Coffee[] cRef = new Coffee[]{new Coffee(1, "hazelnut", 1.0f), new Coffee(2, "vanilla creme", 2.0f), new Coffee(3, "decaf", 3.0f), new Coffee(4, "breakfast blend", 4.0f), new Coffee(5, "mocha", 5.0f)};
            this.logTrace("Start to persist coffees ");
            for (Coffee c : cRef) {
                if (c == null) continue;
                this.getEntityManager().persist((Object)c);
                this.logTrace("persisted coffee " + String.valueOf(c));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

