/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.xa.ee.resXcomp2;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.xa.ee.resXcomp2.Ejb1Test;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="xa"), @Tag(value="platform")})
public class Client
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private Properties testProps = null;
    private static final String txRef = "java:comp/env/ejb/MyEjbReference";
    private Ejb1Test beanRef = null;
    private UserTransaction ut = null;
    private String tName1 = null;
    private int[] expResultstest1ds = new int[]{1, 2, 3};

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.testProps = p;
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"Setup tests");
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup Ejb1Test: java:comp/env/ejb/MyEjbReference");
            this.beanRef = (Ejb1Test)this.nctx.lookup(txRef, Ejb1Test.class);
            TestUtil.logMsg((String)"Lookup java:comp/UserTransaction");
            this.ut = (UserTransaction)this.nctx.lookup("java:comp/UserTransaction");
            TestUtil.logMsg((String)"Lookup environment variables");
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"Xa_Tab1_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
            TestUtil.logMsg((String)"Initialize java:comp/env/ejb/MyEjbReference");
            this.beanRef.initialize(this.testProps);
            TestUtil.logMsg((String)"Initialize logging data from server in Client");
            this.beanRef.initLogging(p);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in setup: ", (Throwable)e);
            throw new Exception("setup failed", e);
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"Cleanup ok");
    }

    public void test5() throws Exception {
        String testname = "test5";
        boolean testResult = false;
        String tName1 = this.tName1;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a commit to a single table");
            TestUtil.logMsg((String)"Database access is performed from EJB1Test and EJB2Test");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            this.beanRef.destroyData(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert rows");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            TestUtil.logMsg((String)"Calling insert in Ejb1");
            this.beanRef.insert(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            testResult = this.beanRef.verifyData(new String("commit"), tName1, this.expResultstest1ds);
            TestUtil.logTrace((String)"Test results");
            if (!testResult) {
                TestUtil.logMsg((String)(testResult + " - verification of data failed"));
            } else {
                TestUtil.logMsg((String)(testResult + " - verification of data successfull"));
            }
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName1);
                this.beanRef.destroyData(tName1);
                this.beanRef.dbUnConnect(tName1);
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test6() throws Exception {
        String testname = "test6";
        boolean testResult = false;
        String tName1 = this.tName1;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a rollback to a single table");
            TestUtil.logMsg((String)"Database access is performed from EJB1Test and EJB2Test");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            this.beanRef.destroyData(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert rows");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            TestUtil.logMsg((String)"Calling insert in Ejb1");
            this.beanRef.insert(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.rollback();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            testResult = this.beanRef.verifyData(new String("rollback"), tName1, this.expResultstest1ds);
            TestUtil.logTrace((String)"Test results");
            if (!testResult) {
                TestUtil.logMsg((String)(testResult + " - verification of data failed"));
            } else {
                TestUtil.logMsg((String)(testResult + " - verification of data successfull"));
            }
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName1);
                this.beanRef.destroyData(tName1);
                this.beanRef.dbUnConnect(tName1);
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test7() throws Exception {
        String testname = "test7";
        boolean testResult = false;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a commit to a single table");
            TestUtil.logMsg((String)"Database access is performed from EJB1Test and EJB2Test");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            this.beanRef.destroyData("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Insert rows");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            TestUtil.logMsg((String)"Calling insert in Ejb1");
            this.beanRef.insert("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            testResult = this.beanRef.verifyData("commit", "EIS", this.expResultstest1ds);
            TestUtil.logTrace((String)("Test results : " + testResult));
            if (!testResult) {
                TestUtil.logMsg((String)(testResult + " - verification of data failed"));
            } else {
                TestUtil.logMsg((String)(testResult + " - verification of data successfull"));
            }
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect("EIS");
                this.beanRef.destroyData("EIS");
                this.beanRef.dbUnConnect("EIS");
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test8() throws Exception {
        String testname = "test8";
        boolean testResult = false;
        try {
            TestUtil.logTrace((String)testname);
            TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
            TestUtil.logMsg((String)"Insert/Delete followed by a rollback to a single table");
            TestUtil.logMsg((String)"Database access is performed from EJB1Test and EJB2Test");
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            this.beanRef.destroyData("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
            TestUtil.logMsg((String)"Insert rows");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            TestUtil.logMsg((String)"Calling insert in Ejb1");
            this.beanRef.insert("EIS");
            this.beanRef.dbUnConnect("EIS");
            this.ut.rollback();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect("EIS");
            testResult = this.beanRef.verifyData("rollback", "EIS", this.expResultstest1ds);
            TestUtil.logTrace((String)("Test results : " + testResult));
            if (!testResult) {
                TestUtil.logMsg((String)(testResult + " - verification of data failed"));
            } else {
                TestUtil.logMsg((String)(testResult + " - verification of data successfull"));
            }
            this.beanRef.dbUnConnect("EIS");
            this.ut.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect("EIS");
                this.beanRef.destroyData("EIS");
                this.beanRef.dbUnConnect("EIS");
                this.ut.commit();
            }
            catch (Exception exception) {}
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }
}

