/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Alert;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.CookieUtils;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.Beans;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public final class AlertRenderer
extends AbstractRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Alert alert = (Alert)component;
        String summary = alert.getSummary();
        if (summary == null || summary.trim().length() == 0) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String spacerPath = theme.getImagePath("DOT");
        String[] styles = AlertRenderer.getStyles(theme);
        if (!RenderingUtilities.isPortlet(context) && !Beans.isDesignTime()) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String viewId = context.getViewRoot().getViewId();
            String urlString = context.getApplication().getViewHandler().getActionURL(context, viewId);
            viewId = CookieUtils.getValidCookieName(viewId);
            Cookie cookie = new Cookie(viewId, "");
            cookie.setPath(urlString);
            response.addCookie(cookie);
        }
        String defaultStyleClass = theme.getStyleClass("ALERT_DIV");
        AlertRenderer.renderOuterDiv(context, alert, defaultStyleClass, writer);
        this.renderOpeningTable(alert, writer);
        this.renderTopRow(alert, spacerPath, styles, writer);
        this.renderMiddleRow(alert, spacerPath, styles, context, writer);
        AlertRenderer.renderBottomRow(alert, theme, spacerPath, styles, writer);
        AlertRenderer.renderClosingTags(writer);
    }

    protected static void renderOuterDiv(FacesContext context, Alert alert, String defaultStyleClass, ResponseWriter writer) throws IOException {
        String styleClass;
        String style = alert.getStyle();
        String id = alert.getClientId(context);
        writer.startElement("div", (UIComponent)alert);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        styleClass = (styleClass = alert.getStyleClass()) == null || styleClass.length() == 0 ? defaultStyleClass : null;
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)alert, styleClass);
    }

    protected void renderOpeningTable(Alert alert, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)alert);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        writer.writeText((Object)"\n", null);
    }

    protected void renderTopRow(Alert alert, String spacerPath, String[] styles, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)alert);
        writer.writeText((Object)"\n", null);
        AlertRenderer.renderSpacerCell(alert, styles[0], spacerPath, writer);
        AlertRenderer.renderSpacerCell(alert, styles[1], spacerPath, writer);
        AlertRenderer.renderSpacerCell(alert, styles[2], spacerPath, writer);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderMiddleRow(Alert alert, String spacerPath, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styles[3], null);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styles[4], null);
        writer.writeText((Object)"\n", null);
        AlertRenderer.renderSpacerImage(alert, spacerPath, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        this.renderMiddleCell(context, alert, writer, styles);
        writer.startElement("td", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styles[9], null);
        writer.writeText((Object)"\n", null);
        AlertRenderer.renderSpacerImage(alert, spacerPath, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private static void renderBottomRow(Alert alert, Theme theme, String spacerPath, String[] styles, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)alert);
        writer.writeText((Object)"\n", null);
        AlertRenderer.renderSpacerCell(alert, styles[10], spacerPath, writer);
        AlertRenderer.renderSpacerCell(alert, styles[11], spacerPath, writer);
        AlertRenderer.renderSpacerCell(alert, styles[12], spacerPath, writer);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private static void renderSpacerCell(Alert alert, String styleClass, String spacerPath, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)alert);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styleClass, null);
        AlertRenderer.renderSpacerImage(alert, spacerPath, writer);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
    }

    private void renderMiddleCell(FacesContext context, Alert alert, ResponseWriter writer, String[] styles) throws IOException {
        writer.startElement("td", (UIComponent)alert);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styles[5], null);
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styles[6], null);
        AlertRenderer.renderAlertIcon(context, alert);
        AlertRenderer.renderAlertSummaryText(alert, styles, writer);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        this.renderAlertDetailArea(context, alert, styles, writer);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
    }

    private static void renderAlertIcon(FacesContext context, Alert alert) throws IOException {
        UIComponent alertIcon = alert.getAlertIcon();
        RenderingUtilities.renderComponent(alertIcon, context);
    }

    private static void renderAlertSummaryText(Alert alert, String[] styles, ResponseWriter writer) throws IOException {
        String summary = alert.getSummary();
        if (summary != null) {
            writer.startElement("span", (UIComponent)alert);
            writer.writeAttribute("class", (Object)styles[7], null);
            writer.writeText((Object)"\n", null);
            AlertRenderer.renderFormattedMessage(writer, (UIComponent)alert, summary);
            writer.endElement("span");
            writer.writeText((Object)"\n", null);
        }
    }

    private void renderAlertDetailArea(FacesContext context, Alert alert, String[] styles, ResponseWriter writer) throws IOException {
        String detail = alert.getDetail();
        List children = alert.getChildren();
        if ((detail == null || detail.trim().length() == 0) && children.size() <= 0) {
            return;
        }
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)styles[8], null);
        if (detail != null) {
            writer.startElement("span", (UIComponent)alert);
            writer.writeAttribute("class", (Object)styles[7], null);
            writer.writeAttribute("role", (Object)"alert", null);
            writer.writeText((Object)"\n", null);
            AlertRenderer.renderFormattedMessage(writer, (UIComponent)alert, detail);
            writer.endElement("span");
            writer.writeText((Object)"\n", null);
        }
        super.encodeChildren(context, (UIComponent)alert);
        AlertRenderer.renderAlertLink(context, alert);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    private static void renderAlertLink(FacesContext context, Alert alert) throws IOException {
        UIComponent link = alert.getAlertLink();
        if (link != null) {
            RenderingUtilities.renderComponent(link, context);
        }
    }

    private static void renderClosingTags(ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    private static void renderFormattedMessage(ResponseWriter writer, UIComponent component, String msg) throws IOException {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = parameterList.size() > 0 ? MessageFormat.format(msg, parameterList.toArray(new Object[parameterList.size()])) : msg;
        if (message != null) {
            writer.write(message);
        }
    }

    private static void renderSpacerImage(Alert alert, String spacerPath, ResponseWriter writer) throws IOException {
        writer.startElement("img", (UIComponent)alert);
        writer.writeAttribute("src", (Object)spacerPath, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.endElement("img");
    }

    private static String[] getStyles(Theme theme) {
        String[] styles = new String[]{theme.getStyleClass("ALERT_TOP_LEFT_CORNER"), theme.getStyleClass("ALERT_TOP_MIDDLE"), theme.getStyleClass("ALERT_TOP_RIGHT_CORNER"), theme.getStyleClass("ALERT_MIDDLE_ROW"), theme.getStyleClass("ALERT_LEFT_MIDDLE"), theme.getStyleClass("ALERT_MIDDLE"), theme.getStyleClass("ALERT_HEADER"), theme.getStyleClass("ALERT_TEXT"), theme.getStyleClass("ALERT_DETAILS"), theme.getStyleClass("ALERT_RIGHT_MIDDLE"), theme.getStyleClass("ALERT_BOTTOM_LEFT_CORNER"), theme.getStyleClass("ALERT_BOTTOM_MIDDLE"), theme.getStyleClass("ALERT_BOTTOM_RIGHT_CORNER")};
        return styles;
    }
}

