/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.util;

import jakarta.annotation.Priority;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ServiceLoaders {
    private ServiceLoaders() {
    }

    public static <T> List<T> list(Class<T> type) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return StreamSupport.stream(ServiceLoader.load(type, classLoader).spliterator(), false).sorted(new PriorityComparator()).collect(Collectors.toList());
    }

    private static class PriorityComparator
    implements Comparator<Object> {
        private PriorityComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return Integer.compare(this.getPriority(o2), this.getPriority(o1));
        }

        private int getPriority(Object o) {
            Priority priority = o.getClass().getAnnotation(Priority.class);
            if (priority != null) {
                return priority.value();
            }
            return 0;
        }
    }
}

