/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import java.util.Map;

class RespawnInfo {
    private final String classname;
    private final String classpath;
    private final String modulepath;
    private final String[] args;
    private static final String PREFIX = "-asadmin-";
    private static final String SEPARATOR = ",,,";

    RespawnInfo(String cn, String modulepath, String cp, String[] args) {
        this.classname = cn;
        this.classpath = cp;
        this.modulepath = modulepath;
        if (args == null) {
            args = new String[]{};
        }
        this.args = args;
    }

    void put(Map<String, String> map) throws GFLauncherException {
        this.validate();
        map.put("-asadmin-classname", this.classname);
        map.put("-asadmin-classpath", this.classpath);
        map.put("-asadmin-modulepath", this.modulepath);
        this.putArgs(map);
    }

    private void validate() throws GFLauncherException {
        if (!this.ok(this.classname)) {
            throw new GFLauncherException("respawninfo.empty", "classname");
        }
        if (!this.ok(this.classpath)) {
            throw new GFLauncherException("respawninfo.empty", "classpath");
        }
    }

    private void putArgs(Map<String, String> map) throws GFLauncherException {
        int numArgs = this.args.length;
        StringBuilder argLine = new StringBuilder();
        for (int i = 0; i < numArgs; ++i) {
            String arg = this.args[i];
            if (i != 0) {
                argLine.append(SEPARATOR);
            }
            if (arg.indexOf(SEPARATOR) >= 0) {
                throw new GFLauncherException("respawninfo.illegalToken", arg, SEPARATOR);
            }
            argLine.append(this.args[i]);
        }
        map.put("-asadmin-args", argLine.toString());
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

