/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.jersey.jettison.JettisonConfig;
import org.glassfish.jersey.jettison.JettisonConfigured;
import org.glassfish.jersey.jettison.JettisonUnmarshaller;
import org.glassfish.jersey.jettison.internal.Stax2JettisonFactory;

public class BaseJsonUnmarshaller
implements JettisonUnmarshaller,
JettisonConfigured {
    protected final Unmarshaller jaxbUnmarshaller;
    protected final JettisonConfig jsonConfig;

    public BaseJsonUnmarshaller(JAXBContext jaxbContext, JettisonConfig jsonConfig) throws JAXBException {
        this(jaxbContext.createUnmarshaller(), jsonConfig);
    }

    public BaseJsonUnmarshaller(Unmarshaller jaxbUnmarshaller, JettisonConfig jsonConfig) {
        this.jaxbUnmarshaller = jaxbUnmarshaller;
        this.jsonConfig = jsonConfig;
    }

    @Override
    public JettisonConfig getJSONConfiguration() {
        return this.jsonConfig;
    }

    @Override
    public <T> T unmarshalFromJSON(InputStream inputStream, Class<T> expectedType) throws JAXBException {
        return this.unmarshalFromJSON(new InputStreamReader(inputStream, StandardCharsets.UTF_8), expectedType);
    }

    @Override
    public <T> T unmarshalFromJSON(Reader reader, Class<T> expectedType) throws JAXBException {
        if (!expectedType.isAnnotationPresent(XmlRootElement.class)) {
            return (T)this.unmarshalJAXBElementFromJSON(reader, expectedType).getValue();
        }
        return (T)this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader));
    }

    @Override
    public <T> JAXBElement<T> unmarshalJAXBElementFromJSON(InputStream inputStream, Class<T> declaredType) throws JAXBException {
        return this.unmarshalJAXBElementFromJSON(new InputStreamReader(inputStream, StandardCharsets.UTF_8), declaredType);
    }

    @Override
    public <T> JAXBElement<T> unmarshalJAXBElementFromJSON(Reader reader, Class<T> declaredType) throws JAXBException {
        return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader), declaredType);
    }

    private XMLStreamReader createXmlStreamReader(Reader reader) throws JAXBException {
        try {
            return Stax2JettisonFactory.createReader(reader, this.jsonConfig);
        }
        catch (XMLStreamException ex) {
            throw new UnmarshalException("Error creating JSON-based XMLStreamReader", (Throwable)ex);
        }
    }
}

