/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLIProcessExecutor;
import com.sun.enterprise.admin.cli.optional.DatabaseCommand;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-database")
@PerLookup
public final class StartDatabaseCommand
extends DatabaseCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDatabaseCommand.class);
    private static final String DATABASE_DIR_NAME = "databases";
    @Param(name="dbhome", optional=true)
    private String dbHome;
    @Param(name="dbname", optional=true)
    private String dbName;
    @Param(optional=true)
    private String sqlfilename;
    @Param(name="dbuser", optional=true)
    private String dbUser;
    @Param(name="dbpassword", optional=true, password=true)
    private String dbPassword;
    @Param(name="jvmoptions", optional=true, separator=32)
    private String[] jvmoptions;
    @Param(optional=true, shortName="s", defaultValue="false")
    private boolean suspend;

    public String[] startDatabaseCmd() {
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java");
        cmd.add("-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib");
        if (OS.isDarwin()) {
            cmd.add("-Dderby.storage.fileSyncTransactionLog=True");
        }
        if (this.suspend) {
            cmd.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=localhost:9011");
        }
        cmd.add("--module-path");
        cmd.add(this.modulepath.toString());
        cmd.add("--add-modules");
        cmd.add("ALL-MODULE-PATH");
        cmd.add("-cp");
        cmd.add(String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath));
        if (this.jvmoptions != null) {
            cmd.addAll(Arrays.asList(this.jvmoptions));
        }
        cmd.add("com.sun.enterprise.admin.cli.optional.DerbyControl");
        cmd.add("start");
        cmd.add(this.dbHost);
        cmd.add(this.dbPort);
        cmd.add("true");
        cmd.add(this.dbHome);
        return cmd.toArray(new String[cmd.size()]);
    }

    public String[] sysinfoCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "--module-path", this.modulepath.toString(), "--add-modules", "ALL-MODULE-PATH", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
        }
        return new String[]{String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "--module-path", this.modulepath.toString(), "--add-modules", "ALL-MODULE-PATH", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
    }

    public String[] executeSQLCmd() throws Exception {
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java");
        cmd.add("-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib");
        if (this.suspend) {
            cmd.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=localhost:9012");
        }
        cmd.add("--module-path");
        cmd.add(this.modulepath.toString());
        cmd.add("--add-modules");
        cmd.add("ALL-MODULE-PATH");
        cmd.add("-cp");
        cmd.add(String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath));
        cmd.add("com.sun.enterprise.admin.cli.optional.DerbyExecuteSQL");
        cmd.add(this.dbHost);
        cmd.add(this.dbPort);
        cmd.add(this.dbName);
        cmd.add(this.sqlfilename);
        if (!Utility.isAnyNull((Object[])new Object[]{this.dbUser, this.dbPassword})) {
            cmd.add(this.dbUser);
            cmd.add(this.dbPassword);
        }
        return (String[])cmd.toArray(String[]::new);
    }

    private String getDatabaseHomeDir() {
        if (this.dbHome != null) {
            return this.dbHome;
        }
        String currentDir = System.getProperty("user.dir");
        if (new File(currentDir, "derby.log").exists()) {
            return currentDir;
        }
        File installPath = GFLauncherUtils.getInstallDir();
        if (installPath != null) {
            File dbDir = new File(installPath, DATABASE_DIR_NAME);
            if (!dbDir.isDirectory() && !dbDir.mkdir()) {
                logger.warning(strings.get("CantCreateDatabaseDir", new Object[]{dbDir}));
            }
            try {
                return dbDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                return dbDir.getAbsolutePath();
            }
        }
        return null;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        CLIProcessExecutor cliProcessExecutor = new CLIProcessExecutor();
        Object dbLog = "";
        int exitCode = 0;
        try {
            this.prepareProcessExecutor();
            this.dbHome = this.getDatabaseHomeDir();
            if (this.dbHome != null) {
                dbLog = this.dbHome + File.separator + "derby.log";
            }
            logger.finer("Ping Database");
            cliProcessExecutor.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
            if (cliProcessExecutor.exitValue() > 0) {
                logger.finer("Start Database");
                cliProcessExecutor.execute("startDatabaseCmd", this.startDatabaseCmd(), false);
                if (cliProcessExecutor.exitValue() != 0) {
                    throw new CommandException(strings.get("UnableToStartDatabase", new Object[]{dbLog}));
                }
            } else {
                if (cliProcessExecutor.exitValue() < 0) {
                    throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}));
                }
                logger.info(strings.get("StartDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
            }
        }
        catch (IllegalThreadStateException ite) {
            CLIProcessExecutor cpePing = new CLIProcessExecutor();
            CLIProcessExecutor cpeSysInfo = new CLIProcessExecutor();
            try {
                if (!this.programOpts.isTerse()) {
                    logger.fine(strings.get("database.info.msg", new Object[]{this.dbHost, this.dbPort}));
                }
                cpePing.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
                for (int counter = 0; cpePing.exitValue() != 0 && (this.suspend || counter < 10); ++counter) {
                    cpePing.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
                    Thread.sleep(500L);
                    try {
                        cliProcessExecutor.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException itse) {
                        continue;
                    }
                }
                if (!this.programOpts.isTerse()) {
                    logger.finer("Database SysInfo");
                    if (cpePing.exitValue() == 0) {
                        cpeSysInfo.execute("sysinfoCmd", this.sysinfoCmd(), true);
                        if (cpeSysInfo.exitValue() != 0) {
                            logger.info(strings.get("CouldNotGetSysInfo"));
                        }
                    }
                }
                if (cpePing.exitValue() == 0 && !Utility.isAnyNull((Object[])new Object[]{this.dbName, this.sqlfilename})) {
                    cpeSysInfo.execute("executeSQLCmd", this.executeSQLCmd(), true);
                    if (cpeSysInfo.exitValue() != 0) {
                        logger.info("Failed to execute SQL to init DB.");
                    }
                }
            }
            catch (Exception e) {
                throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
            }
            if (cpePing.exitValue() == 0) {
                logger.info(strings.get("DatabaseStartMsg"));
                if (new File((String)dbLog).canWrite()) {
                    logger.info(strings.get("LogRedirectedTo", new Object[]{dbLog}));
                }
            }
            throw new CommandException(strings.get("UnableToStartDatabase", new Object[]{dbLog}));
        }
        catch (Exception e) {
            throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
        return exitCode;
    }
}

