/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.shared.common.error.StandardException;

public final class DeferredConstraintsMemory {
    public static BackingStoreHashtable rememberDuplicate(LanguageConnectionContext languageConnectionContext, BackingStoreHashtable backingStoreHashtable, UUID uUID, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2;
        int n = dataValueDescriptorArray.length - 1;
        if (backingStoreHashtable == null) {
            dataValueDescriptorArray2 = languageConnectionContext.getDeferredHashTables();
            ValidationInfo validationInfo = (ValidationInfo)dataValueDescriptorArray2.get(uUID);
            if (validationInfo == null) {
                backingStoreHashtable = DeferredConstraintsMemory.makeDeferredHashTable(languageConnectionContext.getTransactionExecute(), n);
                dataValueDescriptorArray2.put(uUID, new UniquePkInfo(backingStoreHashtable, uUID));
            } else {
                backingStoreHashtable = validationInfo.infoRows;
            }
        }
        dataValueDescriptorArray2 = new DataValueDescriptor[n];
        System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, n);
        backingStoreHashtable.putRow(true, dataValueDescriptorArray2, null);
        return backingStoreHashtable;
    }

    public static BackingStoreHashtable rememberCheckViolations(LanguageConnectionContext languageConnectionContext, UUID uUID, String string, String string2, BackingStoreHashtable backingStoreHashtable, List<UUID> list, RowLocation rowLocation, CheckInfo[] checkInfoArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        if (list.isEmpty()) {
            return null;
        }
        if (backingStoreHashtable == null) {
            dataValueDescriptorArray = languageConnectionContext.getDeferredHashTables();
            CheckInfo checkInfo = (CheckInfo)dataValueDescriptorArray.get(uUID);
            if (checkInfo == null) {
                backingStoreHashtable = DeferredConstraintsMemory.makeDeferredHashTable(languageConnectionContext.getTransactionExecute(), 1);
                CheckInfo checkInfo2 = new CheckInfo(backingStoreHashtable, string, string2, list);
                dataValueDescriptorArray.put(uUID, checkInfo2);
                checkInfoArray[0] = checkInfo2;
            } else {
                checkInfo.addCulprits(list);
                backingStoreHashtable = checkInfo.infoRows;
                checkInfoArray[0] = checkInfo;
            }
        }
        dataValueDescriptorArray = new DataValueDescriptor[]{new SQLRef(rowLocation).cloneValue(true)};
        backingStoreHashtable.putRow(true, dataValueDescriptorArray, null);
        return backingStoreHashtable;
    }

    public static Enumeration<Object> getDeferredCheckConstraintLocations(Activation activation, UUID uUID) throws StandardException {
        CheckInfo checkInfo = (CheckInfo)activation.getLanguageConnectionContext().getDeferredHashTables().get(uUID);
        return checkInfo.infoRows.elements();
    }

    public static BackingStoreHashtable rememberFKViolation(LanguageConnectionContext languageConnectionContext, BackingStoreHashtable backingStoreHashtable, UUID uUID, DataValueDescriptor[] dataValueDescriptorArray, String string, String string2) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2;
        if (backingStoreHashtable == null) {
            dataValueDescriptorArray2 = languageConnectionContext.getDeferredHashTables();
            ValidationInfo validationInfo = (ValidationInfo)dataValueDescriptorArray2.get(uUID);
            if (validationInfo == null) {
                backingStoreHashtable = DeferredConstraintsMemory.makeDeferredHashTable(languageConnectionContext.getTransactionExecute(), dataValueDescriptorArray.length);
                dataValueDescriptorArray2.put(uUID, new ForeignKeyInfo(backingStoreHashtable, uUID, string, string2));
            } else {
                backingStoreHashtable = validationInfo.infoRows;
            }
        }
        dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
        backingStoreHashtable.putRow(true, dataValueDescriptorArray2, null);
        return backingStoreHashtable;
    }

    private static BackingStoreHashtable makeDeferredHashTable(TransactionController transactionController, int n) throws StandardException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return new BackingStoreHashtable(transactionController, null, nArray, true, -1L, -1L, -1, -1.0f, false, false);
    }

    public static void compressOrTruncate(LanguageConnectionContext languageConnectionContext, UUID uUID, String string) throws StandardException {
        HashMap<UUID, ValidationInfo> hashMap = languageConnectionContext.getDeferredHashTables();
        TableDescriptor tableDescriptor = languageConnectionContext.getDataDictionary().getTableDescriptor(uUID);
        ValidationInfo validationInfo = hashMap.get(uUID);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", string);
        }
        if (validationInfo != null && validationInfo instanceof CheckInfo) {
            ((CheckInfo)validationInfo).setInvalidatedRowLocations();
        }
    }

    public static abstract class ValidationInfo {
        public final BackingStoreHashtable infoRows;

        public ValidationInfo(BackingStoreHashtable backingStoreHashtable) {
            this.infoRows = backingStoreHashtable;
        }

        public abstract void possiblyValidateOnReturn(LanguageConnectionContext var1, SQLSessionContext var2, SQLSessionContext var3) throws StandardException;

        public abstract void validateConstraint(LanguageConnectionContext var1, UUID var2, boolean var3) throws StandardException;
    }

    private static class UniquePkInfo
    extends ValidationInfo {
        private final UUID constraintId;

        public UniquePkInfo(BackingStoreHashtable backingStoreHashtable, UUID uUID) {
            super(backingStoreHashtable);
            this.constraintId = uUID;
        }

        @Override
        public final void possiblyValidateOnReturn(LanguageConnectionContext languageConnectionContext, SQLSessionContext sQLSessionContext, SQLSessionContext sQLSessionContext2) throws StandardException {
            if (languageConnectionContext.isEffectivelyDeferred(sQLSessionContext2, this.constraintId)) {
                return;
            }
            this.validateUniquePK(languageConnectionContext, this.infoRows, true);
        }

        @Override
        public final void validateConstraint(LanguageConnectionContext languageConnectionContext, UUID uUID, boolean bl) throws StandardException {
            this.validateUniquePK(languageConnectionContext, this.infoRows, bl);
        }

        private void validateUniquePK(LanguageConnectionContext languageConnectionContext, BackingStoreHashtable backingStoreHashtable, boolean bl) throws StandardException {
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            Enumeration<Object> enumeration = backingStoreHashtable.elements();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            KeyConstraintDescriptor keyConstraintDescriptor = (KeyConstraintDescriptor)dataDictionary.getConstraintDescriptor(this.constraintId);
            if (keyConstraintDescriptor == null) {
                return;
            }
            long l = keyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber();
            while (enumeration.hasMoreElements()) {
                DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])enumeration.nextElement();
                GenericScanController genericScanController = null;
                boolean bl2 = false;
                try {
                    genericScanController = transactionController.openScan(l, false, 0, 6, 3, null, dataValueDescriptorArray, 1, null, dataValueDescriptorArray, -1);
                    if (!genericScanController.next() || !genericScanController.next()) continue;
                    throw StandardException.newException(bl ? "23506.T.1" : "23507.S.1", keyConstraintDescriptor.getConstraintName(), keyConstraintDescriptor.getTableDescriptor().getName());
                }
                catch (StandardException standardException) {
                    bl2 = true;
                    throw standardException;
                }
                finally {
                    try {
                        if (genericScanController == null) continue;
                        genericScanController.close();
                    }
                    catch (StandardException standardException) {
                        if (bl2) continue;
                        throw standardException;
                    }
                }
            }
        }
    }

    public static class CheckInfo
    extends ValidationInfo {
        private final String schemaName;
        private final String tableName;
        private List<UUID> culprits;
        private boolean invalidatedDueToCompress;

        public CheckInfo(BackingStoreHashtable backingStoreHashtable, String string, String string2, List<UUID> list) {
            super(backingStoreHashtable);
            this.schemaName = string;
            this.tableName = string2;
            this.culprits = new ArrayList<UUID>(list);
        }

        public void setInvalidatedRowLocations() {
            this.invalidatedDueToCompress = true;
        }

        public boolean isInvalidated() {
            return this.invalidatedDueToCompress;
        }

        public void addCulprits(List<UUID> list) {
            HashSet<UUID> hashSet = new HashSet<UUID>(this.culprits);
            hashSet.addAll(list);
            this.culprits = new ArrayList<UUID>(hashSet);
        }

        public List<UUID> getCulprints() {
            return this.culprits;
        }

        @Override
        public void possiblyValidateOnReturn(LanguageConnectionContext languageConnectionContext, SQLSessionContext sQLSessionContext, SQLSessionContext sQLSessionContext2) throws StandardException {
            boolean bl = true;
            for (UUID uUID : this.getCulprints()) {
                if (languageConnectionContext.isEffectivelyDeferred(sQLSessionContext2, uUID) || !languageConnectionContext.isEffectivelyDeferred(sQLSessionContext, uUID)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
            this.validateCheck(languageConnectionContext, null, true);
        }

        @Override
        public final void validateConstraint(LanguageConnectionContext languageConnectionContext, UUID uUID, boolean bl) throws StandardException {
            this.validateCheck(languageConnectionContext, uUID, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateCheck(LanguageConnectionContext languageConnectionContext, UUID uUID, boolean bl) throws StandardException {
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
            if (schemaDescriptor == null) {
                return;
            }
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor, transactionController);
            if (tableDescriptor != null) {
                String string = tableDescriptor.getUUID().toString();
                for (UUID uUID2 : this.culprits) {
                    if (uUID != null && !uUID.equals(uUID2)) continue;
                    ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(uUID2);
                    if (constraintDescriptor == null) break;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("SELECT 1 FROM ");
                    stringBuilder.append(tableDescriptor.getQualifiedName());
                    if (!this.isInvalidated()) {
                        stringBuilder.append(" --DERBY-PROPERTIES joinStrategy=nestedLoop,                     index=null,                     validateCheckConstraint=");
                        stringBuilder.append(string);
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(" WHERE NOT(");
                    stringBuilder.append(constraintDescriptor.getConstraintText());
                    stringBuilder.append(')');
                    ResultSet resultSet = null;
                    PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(languageConnectionContext.getDefaultSchema(), stringBuilder.toString(), true, true);
                    StatementContext statementContext = null;
                    try {
                        statementContext = languageConnectionContext.pushStatementContext(true, true, stringBuilder.toString(), null, false, 0L);
                        resultSet = (BasicNoPutResultSetImpl)preparedStatement.execute(preparedStatement.getActivation(languageConnectionContext, false), false, 0L);
                        ExecRow execRow = ((BasicNoPutResultSetImpl)resultSet).getNextRowCore();
                        if (execRow != null) {
                            throw StandardException.newException(bl ? "23514.T.1" : "23515.S.1", constraintDescriptor.getConstraintName(), tableDescriptor.getQualifiedName(), constraintDescriptor.getConstraintText());
                        }
                        if (statementContext != null) {
                            languageConnectionContext.popStatementContext(statementContext, null);
                        }
                        if (resultSet == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (statementContext != null) {
                            languageConnectionContext.popStatementContext(statementContext, null);
                        }
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (StandardException standardException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                    }
                    catch (StandardException standardException) {}
                }
            }
        }
    }

    private static class ForeignKeyInfo
    extends ValidationInfo {
        private final UUID fkId;
        private final String schemaName;
        private final String tableName;

        public ForeignKeyInfo(BackingStoreHashtable backingStoreHashtable, UUID uUID, String string, String string2) {
            super(backingStoreHashtable);
            this.fkId = uUID;
            this.tableName = string2;
            this.schemaName = string;
        }

        public UUID getFkId() {
            return this.fkId;
        }

        @Override
        public void possiblyValidateOnReturn(LanguageConnectionContext languageConnectionContext, SQLSessionContext sQLSessionContext, SQLSessionContext sQLSessionContext2) throws StandardException {
            if (languageConnectionContext.isEffectivelyDeferred(sQLSessionContext2, this.getFkId())) {
                return;
            }
            this.validateForeignKey(languageConnectionContext, true);
        }

        @Override
        public final void validateConstraint(LanguageConnectionContext languageConnectionContext, UUID uUID, boolean bl) throws StandardException {
            this.validateForeignKey(languageConnectionContext, bl);
        }

        private void validateForeignKey(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)dataDictionary.getConstraintDescriptor(this.fkId);
            if (foreignKeyConstraintDescriptor == null) {
                return;
            }
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            long[] lArray = new long[]{foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), referencedKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber()};
            Enumeration<Object> enumeration = this.infoRows.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (DataValueDescriptor[])enumeration.nextElement();
                GenericScanController genericScanController = null;
                boolean bl2 = false;
                for (int i = 0; i < 2; ++i) {
                    boolean bl3 = false;
                    try {
                        genericScanController = transactionController.openScan(lArray[i], false, 0, 6, 2, null, (DataValueDescriptor[])objectArray, 1, null, (DataValueDescriptor[])objectArray, -1);
                        if (i == 0) {
                            if (!genericScanController.next()) break;
                            continue;
                        }
                        if (genericScanController.next()) {
                            continue;
                        }
                        bl2 = true;
                        continue;
                    }
                    catch (StandardException standardException) {
                        bl3 = true;
                        throw standardException;
                    }
                    finally {
                        block18: {
                            try {
                                if (genericScanController != null) {
                                    genericScanController.close();
                                }
                            }
                            catch (StandardException standardException) {
                                if (bl3) break block18;
                                throw standardException;
                            }
                        }
                    }
                }
                if (!bl2) continue;
                SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
                TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor, transactionController);
                TableDescriptor tableDescriptor2 = referencedKeyConstraintDescriptor.getTableDescriptor();
                throw StandardException.newException(bl ? "23516.T.1" : "23517.S.1", foreignKeyConstraintDescriptor.getConstraintName(), tableDescriptor.getQualifiedName(), referencedKeyConstraintDescriptor.getConstraintName(), tableDescriptor2.getQualifiedName(), RowUtil.toString(objectArray));
            }
        }
    }
}

