/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.DefaultJobManagerFile;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.inject.Inject;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.common.SubjectUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="attach")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="attach")
@ManagedJob
@AccessRequired(resource={"jobs/job/$jobID"}, action={"attach"})
public class AttachCommand
implements AdminCommand,
AdminCommandEventBroker.AdminCommandListener<Object> {
    public static final String COMMAND_NAME = "attach";
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(AttachCommand.class);
    private static final System.Logger LOG = System.getLogger(AttachCommand.class.getName());
    @Inject
    private JobManagerService jobManagerService;
    @Inject
    private DefaultJobManagerFile defaultJobManagerFile;
    @Param(primary=true, optional=false, multiple=false)
    private String jobID;
    @Param(optional=true)
    private Integer timeout;
    private AdminCommandEventBroker<?> eventBroker;
    private Job detachedJob;

    public void execute(AdminCommandContext context) {
        this.eventBroker = context.getEventBroker();
        this.detachedJob = this.jobManagerService.get(this.jobID);
        String attachedUser = (String)SubjectUtil.getUsernamesFromSubject((Subject)context.getSubject()).get(0);
        ActionReport report = context.getActionReport();
        if (this.detachedJob == null) {
            LOG.log(System.Logger.Level.TRACE, "Trying to find completed job id: {0}", this.jobID);
            JobInfo jobInfo = this.jobManagerService.getCompletedJobForId(this.jobID, this.defaultJobManagerFile.getFile());
            this.attachCompleted(jobInfo, attachedUser, report);
        } else {
            this.attachRunning(attachedUser, report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdminCommandEvent(String eventName, Object event) {
        LOG.log(System.Logger.Level.TRACE, "onAdminCommandEvent(eventName={0}, event={1})", eventName, event);
        if (eventName == null || eventName.startsWith("client.")) {
            return;
        }
        this.eventBroker.fireEvent(eventName, event);
        if (!this.detachedJob.isJobStillActive()) {
            Job job = this.detachedJob;
            synchronized (job) {
                this.detachedJob.notifyAll();
            }
        }
    }

    private void attachCompleted(JobInfo jobInfo, String attachedUser, ActionReport report) {
        LOG.log(System.Logger.Level.DEBUG, "attachCompleted(jobInfo={0}, attachedUser={1}, report={2})", jobInfo, attachedUser, report);
        if (jobInfo == null || this.isInvisibleJob(jobInfo.jobName)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("attach.wrong.commandinstance.id", "Job with id {0} does not exist.", new Object[]{this.jobID}));
            return;
        }
        if (!jobInfo.user.equals(attachedUser)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("user.not.authorized", "User {0} not authorized to attach to job {1}", new Object[]{attachedUser, this.jobID}));
            return;
        }
        if (jobInfo.state.equals(AdminCommandState.State.COMPLETED.toString()) || jobInfo.state.equals(AdminCommandState.State.REVERTED.toString())) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.appendMessage(strings.getLocalString("attach.finished", "Command {0} executed with status {1}", new Object[]{jobInfo.jobName, jobInfo.exitCode}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachRunning(String attachedUser, ActionReport report) {
        LOG.log(System.Logger.Level.DEBUG, "attachRunning(attachedUser={0}, report={1})", attachedUser, report);
        if (this.detachedJob == null || this.isInvisibleJob(this.detachedJob.getName())) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("attach.wrong.commandinstance.id", "Job with id {0} does not exist.", new Object[]{this.jobID}));
            return;
        }
        String jobInitiator = (String)this.detachedJob.getSubjectUsernames().get(0);
        if (!attachedUser.equals(jobInitiator)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("user.not.authorized", "User {0} not authorized to attach to job {1}", new Object[]{attachedUser, this.jobID}));
            return;
        }
        this.eventBroker.fireEvent("AdminCommandState/stateChanged", (Object)this.detachedJob);
        CommandProgress commandProgress = this.detachedJob.getCommandProgress();
        if (commandProgress != null) {
            this.eventBroker.fireEvent("ProgressStatus/state", (Object)commandProgress);
        }
        this.detachedJob.getEventBroker().registerListener(".*", (AdminCommandEventBroker.AdminCommandListener)this);
        LOG.log(System.Logger.Level.TRACE, "Waiting until job {0} is finished.", this.detachedJob);
        Job job = this.detachedJob;
        synchronized (job) {
            if (this.detachedJob.isJobStillActive()) {
                try {
                    if (this.timeout == null) {
                        this.detachedJob.wait();
                    } else {
                        this.detachedJob.wait((long)this.timeout.intValue() * 1000L);
                        if (this.detachedJob.isJobStillActive()) {
                            LOG.log(System.Logger.Level.WARNING, "Job {0} is still in state {1} after timeout {1} seconds.", this.detachedJob.getName(), this.detachedJob.getState(), this.timeout);
                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                            report.setMessage(strings.getLocalString("attach.timeout", "Waiting for job {0} timed out after {1} seconds.", new Object[]{this.detachedJob.getName(), this.timeout}));
                            return;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.log(System.Logger.Level.DEBUG, "Finished waiting for job {0}", this.detachedJob);
            if (AdminCommandState.State.COMPLETED.equals((Object)this.detachedJob.getState()) || AdminCommandState.State.REVERTED.equals((Object)this.detachedJob.getState())) {
                report.setActionExitCode(this.detachedJob.getActionReport().getActionExitCode());
                report.appendMessage(strings.getLocalString("attach.finished", "Command {0} executed with status {1}", new Object[]{this.detachedJob.getName(), this.detachedJob.getActionReport().getActionExitCode()}));
            }
        }
    }

    private boolean isInvisibleJob(String name) {
        return name.startsWith("_") || COMMAND_NAME.equals(name);
    }
}

