/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class PortWatcher {
    private static final System.Logger LOG = System.getLogger(PortWatcher.class.getName());
    private final CompletableFuture<Boolean> job;

    private PortWatcher(Supplier<Boolean> supplier) {
        this.job = CompletableFuture.supplyAsync(supplier);
        Thread.onSpinWait();
    }

    public boolean get(Duration timeout) {
        LOG.log(System.Logger.Level.TRACE, "get(timeout={0})", timeout);
        try {
            if (timeout == null) {
                return this.job.get();
            }
            return this.job.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.job.cancel(true);
            return false;
        }
    }

    public static PortWatcher watch(HostAndPort endpoint, boolean printDots) {
        Objects.requireNonNull(endpoint, "endpoint");
        return new PortWatcher(() -> ProcessUtils.waitWhileListening((HostAndPort)endpoint, null, (boolean)printDots));
    }
}

