/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.ProgressEvent;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;

public class SseEventOutput
extends EventOutput {
    private static final System.Logger LOG = System.getLogger(SseEventOutput.class.getName());
    private final AdminCommandState state;

    SseEventOutput(AdminCommandState state) {
        this.state = state;
    }

    void write(String eventName, ProgressEvent event) {
        if (!this.isClosed()) {
            this.writeJson(eventName, event);
        }
    }

    void write() {
        if (!this.isClosed()) {
            this.writeJson("AdminCommandState/stateChanged", this.state);
        }
    }

    private void writeJson(String eventName, Object event) {
        LOG.log(System.Logger.Level.DEBUG, "write(eventName={0}, event={1}", eventName, event);
        OutboundEvent outEvent = new OutboundEvent.Builder().name(eventName).mediaType(MediaType.APPLICATION_JSON_TYPE).data(event.getClass(), event).build();
        try {
            this.write(outEvent);
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.DEBUG, "Failed to write event.", (Throwable)e);
        }
    }

    public void close() {
        LOG.log(System.Logger.Level.TRACE, "Closing the event output.");
        try {
            super.close();
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.TRACE, "Failed to close the event output.", (Throwable)ex);
        }
    }
}

