/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.AssocWithThreadResourceHandle;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.enterprise.resource.pool.datastructure.DataStructureFactory;
import com.sun.enterprise.resource.pool.datastructure.ListDataStructure;
import com.sun.enterprise.resource.pool.resizer.AssocWithThreadPoolResizer;
import com.sun.enterprise.resource.pool.resizer.Resizer;
import java.util.Hashtable;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class AssocWithThreadResourcePool
extends ConnectionPool {
    private final ThreadLocal<AssocWithThreadResourceHandle> localResource = new ThreadLocal();

    public AssocWithThreadResourcePool(PoolInfo poolInfo, Hashtable env) throws PoolingException {
        super(poolInfo, env);
    }

    @Override
    protected void initializePoolDataStructure() throws PoolingException {
        this.dataStructure = DataStructureFactory.getDataStructure(ListDataStructure.class.getName(), this.dataStructureParameters, this.maxPoolSize, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc) {
        AssocWithThreadResourceHandle handle = this.localResource.get();
        if (handle == null) {
            return null;
        }
        handle.lock();
        try {
            if (handle.getThreadId() != Thread.currentThread().getId() || handle.hasConnectionErrorOccurred() || handle.isUnusable() || !handle.isAssociated()) {
                this.localResource.remove();
                ResourceHandle resourceHandle = null;
                return resourceHandle;
            }
            if (handle.getResourceState().isBusy() || handle.getResourceState().isEnlisted()) {
                ResourceHandle resourceHandle = null;
                return resourceHandle;
            }
            if (this.matchConnections) {
                if (!alloc.matchConnection(handle)) {
                    this.localResource.remove();
                    handle.setAssociated(false);
                    if (this.poolLifeCycleListener != null) {
                        this.poolLifeCycleListener.connectionNotMatched();
                    }
                    ResourceHandle resourceHandle = null;
                    return resourceHandle;
                }
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionMatched();
                }
            }
            if (!this.isConnectionValid(handle, alloc)) {
                this.localResource.remove();
                handle.setAssociated(false);
                ResourceHandle resourceHandle = null;
                return resourceHandle;
            }
            this.setResourceStateToBusy(handle);
            handle.getResourceState().incrementUsageCount();
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionUsed(handle.getId());
                this.poolLifeCycleListener.decrementNumConnFree();
            }
            AssocWithThreadResourceHandle assocWithThreadResourceHandle = handle;
            return assocWithThreadResourceHandle;
        }
        finally {
            handle.unlock();
        }
    }

    @Override
    protected Resizer initializeResizer() {
        return new AssocWithThreadPoolResizer(this.poolInfo, this.dataStructure, this, this, this.preferValidateOverRecreate);
    }

    @Override
    protected boolean isResourceUnused(ResourceHandle h) {
        if (h instanceof AssocWithThreadResourceHandle) {
            return !h.getResourceState().isBusy() && !((AssocWithThreadResourceHandle)h).isAssociated();
        }
        return !h.getResourceState().isBusy();
    }

    @Override
    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc) throws PoolingException {
        ResourceHandle handle = this.resolvePossibleRemoval(super.getUnenlistedResource(spec, alloc));
        if (handle == null) {
            handle = this.searchFreeUnenlisted(alloc);
        }
        if (this.localResource.get() == null && handle instanceof AssocWithThreadResourceHandle) {
            this.setInThreadLocal((AssocWithThreadResourceHandle)handle);
        }
        return handle;
    }

    @Override
    protected synchronized void freeUnenlistedResource(ResourceHandle resourceHandle) {
        if (this.cleanupResource(resourceHandle) && resourceHandle instanceof AssocWithThreadResourceHandle) {
            if (this.maxConnectionUsage > 0 && resourceHandle.getResourceState().getUsageCount() >= this.maxConnectionUsage) {
                this.performMaxConnectionUsageOperation(resourceHandle);
            } else {
                if (!((AssocWithThreadResourceHandle)resourceHandle).isAssociated()) {
                    this.returnResourceToPool(resourceHandle);
                }
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.decrementConnectionUsed(resourceHandle.getId());
                    this.poolLifeCycleListener.incrementNumConnFree(false, this.steadyPoolSize);
                }
            }
            this.notifyWaitingThreads();
        }
    }

    @Override
    public void deleteResource(ResourceHandle handle) {
        try {
            super.deleteResource(handle);
        }
        finally {
            if (handle instanceof AssocWithThreadResourceHandle) {
                ((AssocWithThreadResourceHandle)handle).setUnusable();
            }
        }
    }

    private void setInThreadLocal(AssocWithThreadResourceHandle handle) {
        if (handle == null) {
            return;
        }
        handle.lock();
        try {
            handle.setAssociated(true);
            this.localResource.set(handle);
        }
        finally {
            handle.unlock();
        }
    }

    private ResourceHandle resolvePossibleRemoval(ResourceHandle handle) {
        if (handle == null) {
            return null;
        }
        handle.lock();
        try {
            if (this.dataStructure.getAllResources().contains(handle) && ((AssocWithThreadResourceHandle)handle).isUnusable()) {
                this.dataStructure.removeResource(handle);
                ResourceHandle resourceHandle = null;
                return resourceHandle;
            }
            ResourceHandle resourceHandle = handle;
            return resourceHandle;
        }
        finally {
            handle.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResourceHandle searchFreeUnenlisted(ResourceAllocator allocator) {
        for (ResourceHandle handle : this.dataStructure.getAllResources()) {
            handle.lock();
            try {
                if (handle.getResourceState().isEnlisted() || handle.getResourceState().isBusy() || handle.hasConnectionErrorOccurred() || ((AssocWithThreadResourceHandle)handle).isUnusable() || !this.matchConnection(handle, allocator)) continue;
                this.setResourceStateToBusy(handle);
                ((AssocWithThreadResourceHandle)handle).setAssociated(false);
                ResourceHandle resourceHandle = handle;
                return resourceHandle;
            }
            finally {
                handle.unlock();
            }
        }
        return null;
    }
}

