/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.CatchData;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.asm.TryData;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.CheckContext;
import org.glassfish.rmic.tools.tree.CodeContext;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.LocalMember;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class SynchronizedStatement
extends Statement {
    Expression expr;
    Statement body;
    boolean needReturnSlot;

    public SynchronizedStatement(long where, Expression expr, Statement body) {
        super(126, where);
        this.expr = expr;
        this.body = body;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        CheckContext newctx = new CheckContext(ctx, this);
        vset = this.reach(env, vset);
        vset = this.expr.checkValue(env, newctx, vset, exp);
        if (this.expr.type.equals(Type.tNull)) {
            env.error(this.expr.where, "synchronized.null");
        }
        this.expr = this.convert(env, newctx, Type.tClass(idJavaLangObject), this.expr);
        vset = this.body.check(env, newctx, vset, exp);
        return ctx.removeAdditionalVars(vset.join(newctx.vsBreak));
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        if (this.body != null) {
            this.body = this.body.inline(env, ctx);
        }
        this.expr = this.expr.inlineValue(env, ctx);
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        SynchronizedStatement s = (SynchronizedStatement)this.clone();
        s.expr = this.expr.copyInline(ctx);
        if (this.body != null) {
            s.body = this.body.copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 1;
        if (this.expr != null && (cost += this.expr.costInline(thresh, env, ctx)) >= thresh) {
            return cost;
        }
        if (this.body != null) {
            cost += this.body.costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        ClassDefinition clazz = ctx.field.getClassDefinition();
        this.expr.codeValue(env, ctx, asm);
        ctx = new Context(ctx);
        if (this.needReturnSlot) {
            Type returnType = ctx.field.getType().getReturnType();
            LocalMember localfield = new LocalMember(0L, clazz, 0, returnType, idFinallyReturnValue);
            ctx.declare(env, localfield);
            Environment.debugOutput("Assigning return slot to " + localfield.number);
        }
        LocalMember f1 = new LocalMember(this.where, clazz, 0, Type.tObject, null);
        LocalMember f2 = new LocalMember(this.where, clazz, 0, Type.tInt, null);
        Integer num1 = ctx.declare(env, f1);
        Integer num2 = ctx.declare(env, f2);
        Label endLabel = new Label();
        TryData td = new TryData();
        td.add(null);
        asm.add(this.where, 58, num1);
        asm.add(this.where, 25, num1);
        asm.add(this.where, 194);
        CodeContext bodyctx = new CodeContext(ctx, this);
        asm.add(this.where, -3, td);
        if (this.body != null) {
            this.body.code(env, bodyctx, asm);
        } else {
            asm.add(this.where, 0);
        }
        asm.add(bodyctx.breakLabel);
        asm.add(td.getEndLabel());
        asm.add(this.where, 25, num1);
        asm.add(this.where, 195);
        asm.add(this.where, 167, endLabel);
        CatchData cd = td.getCatch(0);
        asm.add(cd.getLabel());
        asm.add(this.where, 25, num1);
        asm.add(this.where, 195);
        asm.add(this.where, 191);
        asm.add(bodyctx.contLabel);
        asm.add(this.where, 58, num2);
        asm.add(this.where, 25, num1);
        asm.add(this.where, 195);
        asm.add(this.where, 169, num2);
        asm.add(endLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("synchronized ");
        this.expr.print(out);
        out.print(" ");
        if (this.body != null) {
            this.body.print(out, indent);
        } else {
            out.print("{}");
        }
    }
}

