/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.portunif.ProtocolFinder;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-protocol-finder")
@PerLookup
@I18n(value="create.protocol.finder")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.POST, path="create-protocol-finder", description="Create", params={@RestParam(name="protocol", value="$parent")})})
public class CreateProtocolFinder
implements AdminCommand {
    @Param(name="name", primary=true)
    String name;
    @Param(name="protocol", optional=false)
    String protocolName;
    @Param(name="targetprotocol", optional=false)
    String targetName;
    @Param(name="classname", optional=false)
    String classname;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    private ActionReport report;
    @Inject
    ServiceLocator services;
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        this.report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = protocols.findProtocol(this.protocolName);
        Protocol target = protocols.findProtocol(this.targetName);
        try {
            this.validate((ConfigBeanProxy)protocol, "AS-WEB-ADMIN-00013", this.protocolName);
            this.validate((ConfigBeanProxy)target, "AS-WEB-ADMIN-00013", this.targetName);
            Class<?> finderClass = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
            if (!ProtocolFinder.class.isAssignableFrom(finderClass)) {
                this.report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00021"), this.name, this.classname));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            PortUnification unif = (PortUnification)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws PropertyVetoException, TransactionFailure {
                    PortUnification pu = param.getPortUnification();
                    if (pu == null) {
                        pu = (PortUnification)param.createChild(PortUnification.class);
                        param.setPortUnification(pu);
                    }
                    return pu;
                }
            }, (ConfigBeanProxy)protocol);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<PortUnification>(){

                public Object run(PortUnification param) throws PropertyVetoException, TransactionFailure {
                    List list = param.getProtocolFinder();
                    for (org.glassfish.grizzly.config.dom.ProtocolFinder finder : list) {
                        if (!CreateProtocolFinder.this.name.equals(finder.getName())) continue;
                        throw new TransactionFailure(String.format("A protocol finder named %s already exists.", CreateProtocolFinder.this.name));
                    }
                    org.glassfish.grizzly.config.dom.ProtocolFinder finder = (org.glassfish.grizzly.config.dom.ProtocolFinder)param.createChild(org.glassfish.grizzly.config.dom.ProtocolFinder.class);
                    finder.setName(CreateProtocolFinder.this.name);
                    finder.setProtocol(CreateProtocolFinder.this.targetName);
                    finder.setClassname(CreateProtocolFinder.this.classname);
                    list.add(finder);
                    return null;
                }
            }, (ConfigBeanProxy)unif);
        }
        catch (ValidationFailureException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00019"), this.name, e.getMessage() == null ? "No reason given" : e.getMessage()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
            return;
        }
    }

    private void validate(ConfigBeanProxy check, String key, String ... arguments) throws ValidationFailureException {
        if (check == null && this.report != null) {
            this.report.setMessage(MessageFormat.format(rb.getString(key), arguments));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new ValidationFailureException();
        }
    }

    private static class ValidationFailureException
    extends Exception {
        private ValidationFailureException() {
        }
    }
}

