/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.util;

import org.jboss.classfilewriter.code.CodeAttribute;

public class Boxing {
    public static void boxIfNessesary(CodeAttribute ca, String desc) {
        if (desc.length() == 1) {
            char type = desc.charAt(0);
            switch (type) {
                case 'I': {
                    Boxing.boxInt(ca);
                    break;
                }
                case 'J': {
                    Boxing.boxLong(ca);
                    break;
                }
                case 'S': {
                    Boxing.boxShort(ca);
                    break;
                }
                case 'F': {
                    Boxing.boxFloat(ca);
                    break;
                }
                case 'D': {
                    Boxing.boxDouble(ca);
                    break;
                }
                case 'B': {
                    Boxing.boxByte(ca);
                    break;
                }
                case 'C': {
                    Boxing.boxChar(ca);
                    break;
                }
                case 'Z': {
                    Boxing.boxBoolean(ca);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot box unkown primitive type: " + type);
                }
            }
        }
    }

    public static CodeAttribute unbox(CodeAttribute ca, String desc) {
        char type = desc.charAt(0);
        switch (type) {
            case 'I': {
                return Boxing.unboxInt(ca);
            }
            case 'J': {
                return Boxing.unboxLong(ca);
            }
            case 'S': {
                return Boxing.unboxShort(ca);
            }
            case 'F': {
                return Boxing.unboxFloat(ca);
            }
            case 'D': {
                return Boxing.unboxDouble(ca);
            }
            case 'B': {
                return Boxing.unboxByte(ca);
            }
            case 'C': {
                return Boxing.unboxChar(ca);
            }
            case 'Z': {
                return Boxing.unboxBoolean(ca);
            }
        }
        throw new RuntimeException("Cannot unbox unkown primitive type: " + type);
    }

    public static void boxInt(CodeAttribute bc) {
        bc.invokestatic("java.lang.Integer", "valueOf", "(I)Ljava/lang/Integer;");
    }

    public static void boxLong(CodeAttribute bc) {
        bc.invokestatic("java.lang.Long", "valueOf", "(J)Ljava/lang/Long;");
    }

    public static void boxShort(CodeAttribute bc) {
        bc.invokestatic("java.lang.Short", "valueOf", "(S)Ljava/lang/Short;");
    }

    public static void boxByte(CodeAttribute bc) {
        bc.invokestatic("java.lang.Byte", "valueOf", "(B)Ljava/lang/Byte;");
    }

    public static void boxFloat(CodeAttribute bc) {
        bc.invokestatic("java.lang.Float", "valueOf", "(F)Ljava/lang/Float;");
    }

    public static void boxDouble(CodeAttribute bc) {
        bc.invokestatic("java.lang.Double", "valueOf", "(D)Ljava/lang/Double;");
    }

    public static void boxChar(CodeAttribute bc) {
        bc.invokestatic("java.lang.Character", "valueOf", "(C)Ljava/lang/Character;");
    }

    public static void boxBoolean(CodeAttribute bc) {
        bc.invokestatic("java.lang.Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
    }

    public static CodeAttribute unboxInt(CodeAttribute bc) {
        bc.checkcast("java.lang.Number");
        bc.invokevirtual("java.lang.Number", "intValue", "()I");
        return bc;
    }

    public static CodeAttribute unboxLong(CodeAttribute bc) {
        bc.checkcast("java.lang.Number");
        bc.invokevirtual("java.lang.Number", "longValue", "()J");
        return bc;
    }

    public static CodeAttribute unboxShort(CodeAttribute bc) {
        bc.checkcast("java.lang.Number");
        bc.invokevirtual("java.lang.Number", "shortValue", "()S");
        return bc;
    }

    public static CodeAttribute unboxByte(CodeAttribute bc) {
        bc.checkcast("java.lang.Number");
        bc.invokevirtual("java.lang.Number", "byteValue", "()B");
        return bc;
    }

    public static CodeAttribute unboxFloat(CodeAttribute bc) {
        bc.checkcast("java.lang.Number");
        bc.invokevirtual("java.lang.Number", "floatValue", "()F");
        return bc;
    }

    public static CodeAttribute unboxDouble(CodeAttribute bc) {
        bc.checkcast("java.lang.Number");
        bc.invokevirtual("java.lang.Number", "doubleValue", "()D");
        return bc;
    }

    public static CodeAttribute unboxChar(CodeAttribute bc) {
        bc.checkcast("java.lang.Character");
        bc.invokevirtual("java.lang.Character", "charValue", "()C");
        return bc;
    }

    public static CodeAttribute unboxBoolean(CodeAttribute bc) {
        bc.checkcast("java.lang.Boolean");
        bc.invokevirtual("java.lang.Boolean", "booleanValue", "()Z");
        return bc;
    }
}

