/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.HeaderTable;
import org.glassfish.grizzly.http2.hpack.IndexNameValueWriter;

final class LiteralWithIndexingWriter
extends IndexNameValueWriter {
    private boolean tableUpdated;
    private CharSequence name;
    private CharSequence value;
    private int index;

    LiteralWithIndexingWriter() {
        super(64, 6);
    }

    @Override
    LiteralWithIndexingWriter index(int index) {
        super.index(index);
        this.index = index;
        return this;
    }

    @Override
    LiteralWithIndexingWriter name(CharSequence name, boolean useHuffman) {
        super.name(name, useHuffman);
        this.name = name;
        return this;
    }

    @Override
    LiteralWithIndexingWriter value(CharSequence value, boolean useHuffman) {
        super.value(value, useHuffman);
        this.value = value;
        return this;
    }

    @Override
    public boolean write(HeaderTable table, Buffer destination) {
        if (!this.tableUpdated) {
            CharSequence n = this.indexedRepresentation ? table.get((int)this.index).name : this.name;
            table.put(n, this.value);
            this.tableUpdated = true;
        }
        return super.write(table, destination);
    }

    @Override
    public IndexNameValueWriter reset() {
        this.tableUpdated = false;
        this.name = null;
        this.value = null;
        this.index = -1;
        return super.reset();
    }
}

