/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;

public abstract class AbstractIdentityMapEnumeration<T>
implements Enumeration<T> {
    protected final Iterator<CacheKey> cacheKeysIterator;
    protected CacheKey nextKey;
    protected boolean shouldCheckReadLocks;

    protected AbstractIdentityMapEnumeration(Collection<CacheKey> keys, boolean shouldCheckReadLocks) {
        this.shouldCheckReadLocks = shouldCheckReadLocks;
        this.cacheKeysIterator = keys.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        this.nextKey = this.getNextCacheKey();
        return this.nextKey != null;
    }

    @Override
    public abstract T nextElement();

    private CacheKey getNextCacheKey() {
        CacheKey key = null;
        while (this.cacheKeysIterator.hasNext() && key == null) {
            key = this.cacheKeysIterator.next();
        }
        return key;
    }

    protected CacheKey getNextElement() {
        if (this.nextKey == null) {
            throw new NoSuchElementException("AbstractIdentityMapEnumeration nextElement");
        }
        if (this.shouldCheckReadLocks) {
            this.nextKey.checkReadLock();
        }
        return this.nextKey;
    }
}

