/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.impl.util.SerializableJNDIContext;
import com.sun.enterprise.container.common.spi.util.GlassFishOutputStreamHandler;
import com.sun.enterprise.container.common.spi.util.IndirectlySerializable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.naming.Context;
import org.glassfish.common.util.ObjectInputOutputStreamFactory;
import org.glassfish.common.util.ObjectInputOutputStreamFactoryFactory;

class GlassFishObjectOutputStream
extends ObjectOutputStream {
    private final ObjectInputOutputStreamFactory outputStreamHelper;
    private final Collection<GlassFishOutputStreamHandler> handlers;

    GlassFishObjectOutputStream(Collection<GlassFishOutputStreamHandler> handlers, OutputStream out, boolean replaceObject) throws IOException {
        super(out);
        this.handlers = handlers;
        if (replaceObject) {
            this.enableReplaceObject(replaceObject);
        }
        this.outputStreamHelper = ObjectInputOutputStreamFactoryFactory.getFactory();
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        Object result = obj;
        if (obj instanceof IndirectlySerializable) {
            result = ((IndirectlySerializable)obj).getSerializableObjectFactory();
        } else if (obj instanceof Context) {
            result = new SerializableJNDIContext((Context)obj);
        } else {
            for (GlassFishOutputStreamHandler handler : this.handlers) {
                Object r = handler.replaceObject(obj);
                if (r == null) continue;
                result = r;
                break;
            }
        }
        return result;
    }

    @Override
    protected void annotateClass(Class<?> cl) throws IOException {
        this.outputStreamHelper.annotateClass((ObjectOutputStream)this, cl);
    }
}

