/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.web.integration;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.exousia.modules.locked.AuthorizationRoleMapper;
import org.glassfish.internal.api.Globals;

public class GlassfishRoleMapper
implements AuthorizationRoleMapper {
    public Set<Principal> getPrincipalsInRole(String contextId, String roleName) throws SecurityException {
        return this.getPrincipalsInRole(this.getInternalMapper(contextId), roleName);
    }

    private SecurityRoleMapper getInternalMapper(String contextId) {
        SecurityRoleMapperFactory factory = (SecurityRoleMapperFactory)Globals.get(SecurityRoleMapperFactory.class);
        if (factory == null) {
            throw new SecurityException("SecurityRoleMapperFactory lookup failed - null.");
        }
        SecurityRoleMapper securityRoleMapper = factory.getRoleMapper(contextId);
        if (securityRoleMapper == null) {
            throw new SecurityException("Factory failed to provide a SecurityRoleMapper. Factory: " + String.valueOf(factory));
        }
        return securityRoleMapper;
    }

    private Set<Principal> getPrincipalsInRole(SecurityRoleMapper securityRoleMapper, String roleName) throws SecurityException {
        Map roleMap = securityRoleMapper.getRoleToSubjectMapping();
        if (roleMap == null) {
            return null;
        }
        Subject subject = (Subject)roleMap.get(roleName);
        if (subject == null) {
            return null;
        }
        return subject.getPrincipals();
    }
}

