/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.connectors.deployment.annotation.handlers.ConnectionFactoryDefinitionHandler;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.resource.ConnectionFactoryDefinition;
import jakarta.resource.ConnectionFactoryDefinitions;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConnectionFactoryDefinitions.class)
public class ConnectionFactoryDefinitionsHandler
extends AbstractResourceHandler {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ConnectionFactoryDefinitionsHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        ConnectionFactoryDefinitions defns = (ConnectionFactoryDefinitions)ainfo.getAnnotation();
        ConnectionFactoryDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (ConnectionFactoryDefinition defn : values) {
                String defnName = ResourceDescriptor.getJavaComponentJndiName((String)defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = I18N.getLocalString("enterprise.deployment.annotation.handlers.connectionfactorydefinitionsduplicates", "@ConnectionFactoryDefinitions cannot have multiple definitions with same name : ''{0}''", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                ConnectionFactoryDefinitionHandler handler = new ConnectionFactoryDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

