/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignCheck;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignChecker;
import com.sun.enterprise.admin.servermgmt.util.CommandAction;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.main.jdke.security.KeyTool;

public abstract class LocalServerCommand
extends CLICommand {
    private static final System.Logger LOG = System.getLogger(LocalServerCommand.class.getName());
    private ServerDirs serverDirs;

    protected boolean checkForSpecialFiles() {
        return true;
    }

    @Deprecated
    protected final HostAndPort getAdminAddress(String serverName) throws CommandException {
        if (this.isLocal()) {
            List<HostAndPort> addrSet = this.loadAdminAddresses(this.getDomainXml(), serverName);
            if (addrSet.isEmpty()) {
                throw new CommandException("Cannot find admin port in domain.xml file");
            }
            return addrSet.get(0);
        }
        return new HostAndPort(this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure());
    }

    protected HostAndPort getReachableAdminAddress() {
        return this.getReachableAdminAddress(() -> this.loadAdminAddresses(this.getDomainXml(), this.getServerDirs().getServerName()));
    }

    protected final HostAndPort getReachableAdminAddress(Supplier<List<HostAndPort>> adminEndpointCandidatesSupplier) {
        String hostArg = this.programOpts.getPlainOption("host");
        String portArg = this.programOpts.getPlainOption("port");
        Integer port = portArg == null ? null : Integer.valueOf(Integer.parseInt(portArg));
        String secureArg = this.programOpts.getPlainOption("secure");
        Boolean secure = secureArg == null ? null : Boolean.valueOf(secureArg);
        return this.findReachableAdminAddress(hostArg, port, secure, adminEndpointCandidatesSupplier);
    }

    private HostAndPort findReachableAdminAddress(String userHost, Integer userPort, Boolean userSecure, Supplier<List<HostAndPort>> adminEndpointCandidatesSupplier) {
        if (userHost != null && userPort != null && userSecure != null) {
            HostAndPort endpoint = new HostAndPort(userHost, userPort.intValue(), userSecure.booleanValue());
            return ProcessUtils.isListening((HostAndPort)endpoint) ? endpoint : null;
        }
        List<HostAndPort> adminEndpointCandidates = adminEndpointCandidatesSupplier.get();
        if (adminEndpointCandidates.isEmpty()) {
            String host = userHost == null ? "localhost" : userHost;
            Integer port = userPort == null ? 4848 : userPort;
            boolean secure = userSecure == null ? false : userSecure;
            HostAndPort endpoint = new HostAndPort(host, port.intValue(), secure);
            LOG.log(System.Logger.Level.DEBUG, () -> "Checking candidate: " + String.valueOf(endpoint));
            return ProcessUtils.isListening((HostAndPort)endpoint) ? endpoint : null;
        }
        for (HostAndPort candidate : adminEndpointCandidates) {
            String host = userHost == null ? candidate.getHost() : userHost;
            int port = userPort == null ? candidate.getPort() : userPort.intValue();
            boolean secure = userSecure == null ? candidate.isSecure() : userSecure.booleanValue();
            HostAndPort endpoint = new HostAndPort(host, port, secure);
            LOG.log(System.Logger.Level.DEBUG, () -> "Checking candidate: " + String.valueOf(endpoint));
            if (!ProcessUtils.isListening((HostAndPort)endpoint)) continue;
            return endpoint;
        }
        return null;
    }

    protected final List<HostAndPort> loadAdminAddresses(File domainXml, String serverName) {
        try {
            MiniXmlParser parser = new MiniXmlParser(domainXml, serverName);
            return parser.getAdminAddresses();
        }
        catch (MiniXmlParserException e) {
            throw new IllegalStateException("Invalid XML: " + String.valueOf(domainXml), e);
        }
    }

    protected final HostAndPort getUserProvidedAdminAddress() {
        return new HostAndPort(this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure());
    }

    protected final void setServerDirs(ServerDirs sd) {
        this.serverDirs = sd;
    }

    protected final boolean isLocal() {
        return this.serverDirs != null && this.serverDirs.getServerName() != null;
    }

    protected final void setLocalPassword() {
        String pw = this.serverDirs == null ? null : this.serverDirs.getLocalPassword();
        this.programOpts.setPassword(pw == null ? null : pw.toCharArray(), ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
        LOG.log(System.Logger.Level.DEBUG, () -> LocalServerCommand.ok((String)pw) ? "Using local password" : "Not using local password");
    }

    protected final void unsetLocalPassword() {
        this.programOpts.setPassword(null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
    }

    protected final void resetServerDirs() throws IOException {
        if (this.serverDirs == null) {
            throw new IllegalStateException("The setServerDirs() was never called, so the server dirs is null.");
        }
        this.serverDirs = this.serverDirs.refresh();
    }

    protected final ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    protected final File getDomainXml() {
        if (this.serverDirs == null) {
            throw new IllegalStateException("The setServerDirs() was never called, so the server dirs is null.");
        }
        return this.serverDirs.getDomainXml();
    }

    protected final String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "A master password file reading error: " + e.toString(), (Throwable)e);
            return null;
        }
    }

    protected final boolean verifyMasterPassword(String mpv) {
        return this.loadAndVerifyKeystore(this.getJKS(), mpv);
    }

    protected boolean loadAndVerifyKeystore(File jks, String mpv) {
        LOG.log(System.Logger.Level.DEBUG, "loading keystore: " + String.valueOf(jks));
        if (jks == null || mpv == null) {
            return false;
        }
        try {
            new KeyTool(jks, mpv.toCharArray()).loadKeyStore();
            return true;
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.DEBUG, e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected final String getMasterPassword() throws CommandException {
        int countOfRetries = 3;
        long start = System.currentTimeMillis();
        String masterPassword = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
        if (masterPassword == null) {
            masterPassword = "changeit";
            if (!this.verifyMasterPassword(masterPassword) && !this.verifyMasterPassword(masterPassword = this.readFromMasterPasswordFile())) {
                masterPassword = this.retry(3);
            }
        } else if (!this.verifyMasterPassword(masterPassword)) {
            masterPassword = this.retry(3);
        }
        LOG.log(System.Logger.Level.DEBUG, "Time spent in master password extraction: " + (System.currentTimeMillis() - start) + " ms");
        return masterPassword;
    }

    protected final boolean isThisServer(File ourDir, String directoryKey) {
        if (!LocalServerCommand.ok((String)directoryKey)) {
            throw new NullPointerException(directoryKey);
        }
        ourDir = this.getUniquePath(ourDir);
        LOG.log(System.Logger.Level.DEBUG, "Check if server is at location {0}", ourDir);
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("__locations", this.programOpts, this.env);
            ActionReport report = cmd.executeAndReturnActionReport(new String[]{"__locations"});
            String theirDirPath = report.findProperty(directoryKey);
            LOG.log(System.Logger.Level.DEBUG, "Remote server has root directory {0}", theirDirPath);
            if (LocalServerCommand.ok((String)theirDirPath)) {
                File theirDir = this.getUniquePath(new File(theirDirPath));
                return theirDir.equals(ourDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected final Long getServerPid() {
        Long pidFromFile = ProcessUtils.loadPid((File)this.getServerDirs().getPidFile());
        try {
            RemoteCLICommand command = new RemoteCLICommand("__locations", this.programOpts, this.env);
            ActionReport report = command.executeAndReturnActionReport(new String[]{"__locations"});
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                long pidFromAdmin = Long.parseLong(report.findProperty("Pid"));
                if (pidFromFile == null || !pidFromFile.equals(pidFromAdmin)) {
                    LOG.log(System.Logger.Level.ERROR, "PID should be the same: PID from file = " + pidFromFile + ", while PID received from admin endpoint = " + pidFromAdmin);
                }
                return pidFromAdmin;
            }
            return null;
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.ERROR, "The server PID could not be resolved, sending PID from file: " + pidFromFile + ".", (Throwable)e);
            return pidFromFile;
        }
    }

    protected final Duration waitForStop(Long pid, HostAndPort adminAddress, Duration timeout) throws CommandException {
        Duration portTimeout;
        boolean printDots;
        LOG.log(System.Logger.Level.DEBUG, "waitForStop(pid={0}, oldAdminAddress={1}, timeout={2})", pid, adminAddress, timeout);
        Instant start = Instant.now();
        boolean bl = printDots = !this.programOpts.isTerse();
        if (pid == null) {
            portTimeout = timeout;
        } else {
            portTimeout = CommandAction.step("Waiting for process with pid " + pid + " to stop.", timeout, () -> ProcessUtils.waitWhileIsAlive((long)pid, (Duration)timeout, (boolean)printDots));
            if (ProcessUtils.isAlive((long)pid)) {
                throw new CommandException("Timed out waiting for the server process to stop.");
            }
        }
        if (adminAddress == null) {
            return portTimeout;
        }
        boolean portIsFree = ProcessUtils.waitWhileListening((HostAndPort)adminAddress, (Duration)portTimeout, (boolean)printDots);
        if (portIsFree) {
            return timeout == null ? null : timeout.minus(Duration.between(start, Instant.now()));
        }
        throw new CommandException("Timed out waiting for the server to stop after " + timeout.toMillis() + " ms");
    }

    protected final String waitForStart(Long oldPid, ServerLifeSignCheck lifeSignCheck, Supplier<List<HostAndPort>> adminEndpointsSupplier, Duration timeout) throws CommandException {
        Long pid;
        LOG.log(System.Logger.Level.DEBUG, "waitForStart(oldPid={0}, adminEndpoints, timeout={1})", oldPid, timeout);
        boolean printDots = !this.programOpts.isTerse();
        File pidFile = this.getServerDirs().getPidFile();
        Duration startTimeout = oldPid == null ? timeout : CommandAction.step("Waiting for the new PID.", timeout, () -> ProcessUtils.waitForNewPid((long)oldPid, (File)pidFile, (Duration)timeout, (boolean)printDots));
        if (startTimeout != null && startTimeout.isNegative()) {
            throw new CommandException(this.reportPidFileIssue(pidFile));
        }
        Long l = pid = pidFile.isFile() ? ProcessUtils.loadPid((File)pidFile) : null;
        if (pid == null) {
            throw new CommandException(this.reportPidFileIssue(pidFile));
        }
        try {
            this.resetServerDirs();
            this.setLocalPassword();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "The endpoint is alive, but we failed to reset the local password.", (Throwable)e);
        }
        ServerLifeSignChecker checker = new ServerLifeSignChecker(lifeSignCheck, pidFile, adminEndpointsSupplier, printDots);
        ServerLifeSignChecker.GlassFishProcess process = ServerLifeSignChecker.GlassFishProcess.of(pid);
        ServerLifeSignChecker.ServerLifeSigns signs = checker.watchStartup(process, startTimeout);
        String report = this.report(signs, lifeSignCheck.isPrintServerOutput(signs.isError()));
        if (signs.isError()) {
            throw new CommandException(report);
        }
        return report;
    }

    private String reportPidFileIssue(File pidFile) {
        File restartLogFile = this.serverDirs.getRestartLogFile();
        String error = "Could not load the PID number from file " + String.valueOf(pidFile);
        String restartLog = this.loadRestartLog(restartLogFile);
        if (restartLog == null) {
            return error + "\nThe " + String.valueOf(restartLogFile) + " file could not be loaded too.";
        }
        return error + "\n" + restartLog;
    }

    private String report(ServerLifeSignChecker.ServerLifeSigns signs, boolean printOutput) {
        String restartLog;
        StringBuilder report = new StringBuilder(2048);
        report.append('\n').append(signs.getSummary());
        if (signs.getSuggestion() != null) {
            report.append('\n').append(signs.getSuggestion());
        }
        report.append("\n  Location: ").append(this.getServerDirs().getServerDir());
        String situationReport = signs.getSituationReport();
        if (situationReport != null) {
            report.append(signs.getSituationReport());
        }
        if (printOutput && (restartLog = this.loadRestartLog(this.serverDirs.getRestartLogFile())) != null) {
            report.append('\n').append(restartLog);
        }
        return report.append('\n').toString();
    }

    private String loadRestartLog(File logFile) {
        if (logFile == null || !logFile.exists()) {
            return null;
        }
        try {
            String report = "Found restart log file content: \n##########\n" + Files.readString(this.serverDirs.getRestartLogFile().toPath()) + "\n##########\n";
            logFile.delete();
            return report;
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.WARNING, "Failed to read the restart log file: " + String.valueOf(this.serverDirs.getRestartLogFile()), (Throwable)e);
            return null;
        }
    }

    protected final long getUptime() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput(new String[]{"uptime", "--milliseconds"}).trim();
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException("Server is not running, will attempt to start it...");
        }
        LOG.log(System.Logger.Level.DEBUG, () -> "Server uptime: " + up_ms + " ms");
        return up_ms;
    }

    protected final boolean isRestartable() throws CommandException {
        String val;
        RemoteCLICommand cmd = new RemoteCLICommand("_get-runtime-info", this.programOpts, this.env);
        ActionReport report = cmd.executeAndReturnActionReport(new String[]{"_get-runtime-info"});
        return report == null || !LocalServerCommand.ok((String)(val = report.findProperty("restartable_value"))) || !val.equals("false");
    }

    private long parseUptime(String up) {
        try {
            return Long.parseLong(up);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private File getJKS() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(new File(this.serverDirs.getServerDir(), "config"), "cacerts.p12");
        if (mp.canRead()) {
            return mp;
        }
        LOG.log(System.Logger.Level.DEBUG, "File does not exist or is not readable: {0}", mp);
        return null;
    }

    protected File getMasterPasswordFile() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(this.serverDirs.getServerDir(), "master-password.p12");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private String retry(int times) throws CommandException {
        for (int i = 0; i < times; ++i) {
            String mpv;
            String prompt = "Enter master password - (" + (times - i) + ") attempt(s) remain)> ";
            char[] mpvArr = super.readPassword(prompt);
            String string = mpv = mpvArr != null ? new String(mpvArr) : null;
            if (mpv == null) {
                throw new CommandException("The Master Password is required to start the domain.\nNo console, no prompting possible. You should either create the domain\nwith --savemasterpassword=true or provide a password file with the --passwordfile option.");
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            if (i >= times - 1) continue;
            logger.info("Sorry, incorrect master password, retry");
        }
        throw new CommandException("umber of attempts (" + times + ") exhausted, giving up");
    }

    private File getUniquePath(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioex) {
            f = SmartFile.sanitize((File)f);
        }
        return f;
    }
}

