/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.SecurityActions;
import org.jboss.weld.injection.StaticMethodInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.reflection.Reflections;

class VirtualMethodInjectionPoint<T, X>
extends StaticMethodInjectionPoint<T, X> {
    private volatile Map<Class<?>, Method> methods;

    VirtualMethodInjectionPoint(MethodInjectionPoint.MethodInjectionPointType methodInjectionPointType, EnhancedAnnotatedMethod<T, X> enhancedMethod, Bean<?> declaringBean, Class<?> declaringComponentClass, Set<Class<? extends Annotation>> specialParameterMarkers, InjectionPointFactory factory, BeanManagerImpl manager) {
        super(methodInjectionPointType, enhancedMethod, declaringBean, declaringComponentClass, specialParameterMarkers, factory, manager);
        this.methods = Collections.singletonMap(this.getAnnotated().getJavaMember().getDeclaringClass(), this.accessibleMethod);
    }

    @Override
    protected Method getMethod(Object receiver) throws NoSuchMethodException {
        Map<Class<?>, Method> methods = this.methods;
        Method method = this.methods.get(receiver.getClass());
        if (method == null) {
            Method delegate = this.getAnnotated().getJavaMember();
            if ((this.hasDecorators() || MethodInjectionPoint.MethodInjectionPointType.INITIALIZER.equals((Object)this.type)) && (Reflections.isPrivate(delegate) || Reflections.isPackagePrivate(delegate.getModifiers()) && !Objects.equals(delegate.getDeclaringClass().getPackage(), receiver.getClass().getPackage()))) {
                method = this.accessibleMethod;
            } else {
                method = SecurityActions.lookupMethod(receiver.getClass(), delegate.getName(), delegate.getParameterTypes());
                SecurityActions.ensureAccessible(method);
            }
            Map<Class<?>, Method> newMethods = ImmutableMap.builder().putAll(methods).put(receiver.getClass(), method).build();
            this.methods = newMethods;
        }
        return method;
    }

    private boolean hasDecorators() {
        if (this.getBean() instanceof AbstractClassBean) {
            return ((AbstractClassBean)this.getBean()).hasDecorators();
        }
        if (this.getBean() instanceof AbstractProducerBean) {
            return ((AbstractProducerBean)this.getBean()).getDeclaringBean().hasDecorators();
        }
        return false;
    }
}

