/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;

class DerbyIndexInput
extends IndexInput {
    private StorageFile _file;
    private StorageRandomAccessFile _sraf;
    private final ArrayList<IndexInput> _slices = new ArrayList();
    private final long _offset;
    private final long _length;
    private boolean _closed = false;

    DerbyIndexInput(StorageFile storageFile) throws IOException {
        this(storageFile, storageFile.getPath(), 0L, null);
    }

    private DerbyIndexInput(StorageFile storageFile, String string, long l, Long l2) throws IOException {
        super(string);
        this.setConstructorFields(storageFile);
        this._offset = l;
        this._length = l2 == null ? this._sraf.length() - l : l2;
    }

    private void setConstructorFields(StorageFile storageFile) throws IOException {
        this._file = storageFile;
        this._sraf = this._file.getRandomAccessFile("r");
    }

    public IndexInput clone() {
        try {
            IndexInput indexInput = this.slice(this._file.getPath(), 0L, this._length);
            indexInput.seek(this.getFilePointer());
            return indexInput;
        }
        catch (IOException iOException) {
            throw this.wrap(iOException);
        }
    }

    public IndexInput slice(String string, long l, long l2) throws IOException {
        this.checkIfClosed();
        if (l < 0L || l2 < 0L || l > this._length - l2) {
            throw new IllegalArgumentException();
        }
        DerbyIndexInput derbyIndexInput = new DerbyIndexInput(this._file, string, this._offset + l, l2);
        this._slices.add(derbyIndexInput);
        derbyIndexInput.seek(0L);
        return derbyIndexInput;
    }

    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._sraf.close();
            for (IndexInput indexInput : this._slices) {
                indexInput.close();
            }
            this._slices.clear();
            this._file = null;
            this._sraf = null;
        }
    }

    public long getFilePointer() {
        this.checkIfClosed();
        try {
            return this._sraf.getFilePointer() - this._offset;
        }
        catch (IOException iOException) {
            throw this.wrap(iOException);
        }
    }

    public long length() {
        this.checkIfClosed();
        return this._length;
    }

    public void seek(long l) throws IOException {
        this.checkIfClosed();
        this._sraf.seek(this._offset + l);
    }

    public byte readByte() throws IOException {
        this.checkEndOfFile(1);
        return this._sraf.readByte();
    }

    public void readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.checkEndOfFile(n2);
        for (int i = 0; i < n2 && (n3 = this._sraf.read(byArray, n + i, n2 - i)) >= 0; i += n3) {
        }
    }

    private void checkEndOfFile(int n) throws EOFException {
        long l = this._length - this.getFilePointer();
        if ((long)n > l) {
            throw new EOFException();
        }
    }

    private void checkIfClosed() {
        if (this._closed) {
            throw new AlreadyClosedException(this.toString());
        }
    }

    private RuntimeException wrap(Throwable throwable) {
        return new RuntimeException(throwable.getMessage(), throwable);
    }
}

