/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.glassfish.jersey.microprofile.restclient.RestClientProducer;

public class RestClientExtension
implements Extension {
    private Set<Class<?>> interfaces = new HashSet();

    public void collectClientRegistrations(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        Class typeDef = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (!typeDef.isInterface()) {
            throw new DeploymentException("RegisterRestClient annotation has to be on interface! " + typeDef + " is not interface.");
        }
        this.interfaces.add(typeDef);
    }

    public void restClientRegistration(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        this.interfaces.forEach(type -> abd.addBean((Bean)new RestClientProducer((Class<?>)type, bm)));
    }
}

