/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.admin.restconnector.RestConfig;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.ConfigModel;

public class Util {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Util.class);
    private static Client client;

    private Util() {
    }

    public static void logTimingMessage(String msg) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        RestLogging.restLogger.log(Level.INFO, "NCLS-REST-00011", new Object[]{sdf.format(new Date()), msg});
    }

    public static String getResourceName(UriInfo uriInfo) {
        return Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uriInfo.getPath(), '/')));
    }

    public static String getParentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getParentName(uriInfo.getPath());
    }

    public static String getGrandparentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getGrandparentName(uriInfo.getPath());
    }

    public static String getName(String typeName) {
        return Util.getName(typeName, '.');
    }

    public static String getName(String typeName, char delimiter) {
        int index;
        if (typeName == null || "".equals(typeName)) {
            return typeName;
        }
        if (typeName.length() - 1 == typeName.lastIndexOf(delimiter)) {
            typeName = typeName.substring(0, typeName.length() - 1);
        }
        if (typeName.length() > 0 && (index = typeName.lastIndexOf(delimiter)) != -1) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    public static String getParentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getName(url, '/');
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static String getGrandparentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getParentName(url);
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static String eleminateHypen(String string) {
        if (string != null && ((String)string).length() > 0) {
            int index = ((String)string).indexOf(45);
            while (index != -1) {
                string = index == 0 ? ((String)string).substring(1) : (index == ((String)string).length() - 1 ? ((String)string).substring(0, ((String)string).length() - 1) : ((String)string).substring(0, index) + Util.upperCaseFirstLetter(((String)string).substring(index + 1)));
                index = ((String)string).indexOf(45);
            }
        }
        return string;
    }

    public static String decode(String string) {
        String ret = string;
        try {
            ret = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
    }

    public static String lowerCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toLowerCase(Locale.US) + string.substring(1);
    }

    protected static String getHtml(String message, UriInfo uriInfo, boolean delete) {
        Object result = ProviderUtil.getHtmlHeader(uriInfo.getBaseUri().toASCIIString());
        Object uri = uriInfo.getAbsolutePath().toString();
        if (delete) {
            uri = (String)uri + "/..";
        }
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName((String)uri, '/')));
        result = (String)result + "<h1>" + name + "</h1>";
        result = (String)result + message;
        result = (String)result + "<a href=\"" + (String)uri + "\">Back</a>";
        result = (String)result + "</body></html>";
        return result;
    }

    public static String methodNameFromDtdName(String elementName, String prefix) {
        return Util.methodNameFromBeanName(Util.eleminateHypen(elementName), prefix);
    }

    public static String methodNameFromBeanName(String elementName, String prefix) {
        if (null == elementName || null == prefix || prefix.length() <= 0) {
            return elementName;
        }
        return prefix + Util.upperCaseFirstLetter(elementName);
    }

    public static synchronized Client getJerseyClient() {
        if (client == null) {
            client = ClientBuilder.newClient();
        }
        return client;
    }

    public static RestActionReporter applyChanges(Map<String, String> data, UriInfo uriInfo, Subject subject) {
        return Util.applyChanges(data, Util.getBasePathFromUri(uriInfo), subject);
    }

    public static RestActionReporter applyChanges(Map<String, String> data, String basePath, Subject subject) {
        ParameterMap parameters = new ParameterMap();
        Map<String, String> currentValues = Util.getCurrentValues(basePath, subject);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String currentValue = currentValues.get(basePath + entry.getKey());
            if (currentValue != null && !entry.getValue().equals("") && currentValue.equals(entry.getValue())) continue;
            parameters.add((Object)"DEFAULT", (Object)(basePath + entry.getKey() + "=" + entry.getValue()));
        }
        if (parameters.entrySet().isEmpty()) {
            return new RestActionReporter();
        }
        return ResourceUtil.runCommand("set", parameters, subject);
    }

    private static String getBasePathFromUri(UriInfo uriInfo) {
        List pathSegments = uriInfo.getPathSegments();
        PathSegment lastSegment = (PathSegment)pathSegments.get(pathSegments.size() - 1);
        if (lastSegment.getPath().isEmpty()) {
            pathSegments = pathSegments.subList(0, pathSegments.size() - 1);
        }
        List candidatePathSegment = null;
        candidatePathSegment = pathSegments.size() != 1 ? pathSegments.subList(1, pathSegments.size()) : pathSegments;
        StringBuilder sb = new StringBuilder();
        for (PathSegment pathSegment : candidatePathSegment) {
            sb.append(pathSegment.getPath());
            sb.append('.');
        }
        return sb.toString();
    }

    public static Map<String, String> getCurrentValues(String basePath, Subject subject) {
        ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
        return Util.getCurrentValues(basePath, serviceLocator, subject);
    }

    public static Map<String, String> getCurrentValues(String basePath, ServiceLocator habitat, Subject subject) {
        HashMap<String, String> values = new HashMap<String, String>();
        final String path = basePath.endsWith(".") ? basePath.substring(0, basePath.length() - 1) : basePath;
        RestActionReporter gr = ResourceUtil.runCommand("get", new ParameterMap(){
            {
                this.add("DEFAULT", path);
            }
        }, subject);
        ActionReport.MessagePart top = gr.getTopMessagePart();
        for (ActionReport.MessagePart child : top.getChildren()) {
            String message = child.getMessage();
            if (!message.contains("=")) continue;
            String[] parts = message.split("=");
            values.put(parts[0], parts.length > 1 ? parts[1] : "");
        }
        return values;
    }

    public static String getKeyAttributeName(ConfigModel model) {
        if (model == null) {
            return null;
        }
        String keyAttributeName = null;
        if (model.key == null) {
            for (String s : model.getAttributeNames()) {
                if (!s.equals("name")) continue;
                keyAttributeName = Util.getBeanName(s);
            }
        } else {
            keyAttributeName = Util.getBeanName(model.key.substring(1, model.key.length()));
        }
        return keyAttributeName;
    }

    public static String getBeanName(String elementName) {
        StringBuilder ret = new StringBuilder();
        boolean nextisUpper = true;
        for (int i = 0; i < elementName.length(); ++i) {
            if (nextisUpper) {
                ret.append(elementName.substring(i, i + 1).toUpperCase(Locale.US));
                nextisUpper = false;
                continue;
            }
            if (elementName.charAt(i) == '-') {
                nextisUpper = true;
                continue;
            }
            nextisUpper = false;
            ret.append(elementName.substring(i, i + 1));
        }
        return ret.toString();
    }

    public static File createTempDirectory() {
        File baseTempDir = new File(System.getProperty(JAVA_IO_TMPDIR));
        File tempDir = new File(baseTempDir, Long.toString(System.currentTimeMillis()));
        if (!tempDir.mkdirs()) {
            throw new RuntimeException("Unable to create directories");
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static void deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] f = dir.listFiles();
            if (f != null) {
                if (f.length == 0) {
                    if (!dir.delete() && RestLogging.restLogger.isLoggable(Level.WARNING)) {
                        RestLogging.restLogger.log(Level.WARNING, "NCLS-REST-00009", dir.getAbsolutePath());
                    }
                } else {
                    for (File ff : f) {
                        Util.deleteDirectory(ff);
                    }
                }
            }
        } else if (!dir.delete()) {
            if (RestLogging.restLogger.isLoggable(Level.WARNING)) {
                RestLogging.restLogger.log(Level.WARNING, "NCLS-REST-00010", dir.getAbsolutePath());
            }
            dir.deleteOnExit();
        }
    }

    public static String getMethodParameterList(CommandModel cm, boolean withType, boolean includeOptional) {
        StringBuilder sb = new StringBuilder();
        Collection params = cm.getParameters();
        if (params != null && !params.isEmpty()) {
            String sep = "";
            for (CommandModel.ParamModel model : params) {
                Param param = model.getParam();
                if (param.optional() && !includeOptional) continue;
                sb.append(sep);
                if (withType) {
                    Object type = model.getType().getName();
                    if (model.getType().isArray()) {
                        type = model.getType().getName().substring(2);
                        type = ((String)type).substring(0, ((String)type).length() - 1) + "[]";
                    } else if (((String)type).startsWith("java.lang")) {
                        type = model.getType().getSimpleName();
                    }
                    sb.append((String)type);
                }
                sb.append(" _").append(Util.eleminateHypen(model.getName()));
                sep = ", ";
            }
        }
        return sb.toString();
    }

    public static File saveTemporaryFile(String fileName, InputStream fileStream) {
        File file;
        File file2;
        try {
            Path uploadDir = Files.createTempDirectory("gf_uploads", new FileAttribute[0]);
            uploadDir.toFile().deleteOnExit();
            file2 = uploadDir.resolve(fileName).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create a temp file for " + fileName, e);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = fileStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            file2.deleteOnExit();
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not write to a temp file " + String.valueOf(file2), e);
            }
        }
        out.close();
        return file;
    }

    private static String[] getNameAndSuffix(String fileName) {
        if (fileName == null) {
            return new String[2];
        }
        int dotPosition = fileName.lastIndexOf(46);
        if (dotPosition < 1) {
            return new String[]{fileName, null};
        }
        return new String[]{fileName.substring(0, dotPosition), fileName.substring(dotPosition)};
    }

    public static boolean isGenericType(Type type) {
        return ParameterizedType.class.isAssignableFrom(type.getClass());
    }

    public static Class<?> getFirstGenericType(Type genericType) {
        ParameterizedType pt;
        Type[] typeArgs;
        if (genericType instanceof ParameterizedType && (typeArgs = (pt = (ParameterizedType)genericType).getActualTypeArguments()) != null && typeArgs.length >= 1) {
            Type type = typeArgs[0];
            if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            return (Class)type;
        }
        return null;
    }

    public static int getFormattingIndentLevel() {
        RestConfig rg = ResourceUtil.getRestConfig(Globals.getDefaultBaseServiceLocator());
        if (rg == null) {
            return -1;
        }
        return Integer.parseInt(rg.getIndentLevel());
    }

    public static boolean useLegacyResponseFormat(HttpHeaders requestHeaders) {
        boolean legacyHeaderPresent = requestHeaders.getHeaderString("X-GlassFish-3") != null;
        boolean acceptsHtml = requestHeaders.getHeaderString("Accept").contains("html");
        boolean acceptsJson = requestHeaders.getHeaderString("Accept").contains("json");
        return legacyHeaderPresent || acceptsHtml || !acceptsJson;
    }

    public static ParameterMap parameterMap() {
        return new ParameterMap();
    }
}

