/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite.metadata;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.composite.metadata.RestMethodMetadata;

public class RestResourceMetadata {
    private MultivaluedHashMap<String, RestMethodMetadata> resourceMethods = new MultivaluedHashMap();
    private List<String> subResources = new ArrayList<String>();
    private OptionsCapable context;

    public RestResourceMetadata(OptionsCapable context) {
        this.context = context;
        this.processClass();
    }

    public MultivaluedHashMap<String, RestMethodMetadata> getResourceMethods() {
        return this.resourceMethods;
    }

    public void setResourceMethods(MultivaluedHashMap<String, RestMethodMetadata> resourceMethods) {
        this.resourceMethods = resourceMethods;
    }

    public List<String> getSubResources() {
        return this.subResources;
    }

    public void setSubResources(List<String> subResources) {
        this.subResources = subResources;
    }

    private void processClass() {
        for (Method m : this.context.getClass().getMethods()) {
            Path path;
            Annotation designator = this.getMethodDesignator(m);
            if (designator != null) {
                String httpMethod = designator.annotationType().getSimpleName();
                RestMethodMetadata rmm = new RestMethodMetadata(this.context, m, designator);
                this.resourceMethods.add((Object)httpMethod, (Object)rmm);
            }
            if ((path = m.getAnnotation(Path.class)) == null) continue;
            this.subResources.add(this.context.getUriInfo().getAbsolutePathBuilder().build(new Object[0]).toASCIIString() + "/" + path.value());
        }
        Collections.sort(this.subResources);
    }

    private Annotation getMethodDesignator(Method method) {
        GET a = method.getAnnotation(GET.class);
        if (a == null && (a = method.getAnnotation(POST.class)) == null && (a = method.getAnnotation(DELETE.class)) == null) {
            a = method.getAnnotation(OPTIONS.class);
        }
        return a;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject o = new JSONObject();
        if (!this.resourceMethods.isEmpty()) {
            JSONObject methods = new JSONObject();
            for (String key : this.resourceMethods.keySet()) {
                for (RestMethodMetadata rmm : this.resourceMethods.get((Object)key)) {
                    methods.accumulate(key, (Object)rmm.toJson());
                }
            }
            o.accumulate("resourceMethods", (Object)methods);
        }
        if (!this.subResources.isEmpty()) {
            o.put("subResources", this.subResources);
        }
        return o;
    }
}

