/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.factory.file;

import jakarta.security.auth.message.config.AuthConfigFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.glassfish.epicyro.config.factory.RegistrationContextImpl;

public final class AuthConfigProviderEntry {
    private final String className;
    private final Map<String, String> properties;
    private List<AuthConfigFactory.RegistrationContext> registrationContexts;

    public AuthConfigProviderEntry(Class<?> clazz) {
        this(clazz.getName(), null);
    }

    public AuthConfigProviderEntry(String className) {
        this(className, null);
    }

    public AuthConfigProviderEntry(String className, Map<String, String> properties) {
        if (className == null) {
            throw new IllegalArgumentException("Class name for registration entry cannot be null");
        }
        this.className = className;
        this.properties = properties;
    }

    AuthConfigProviderEntry(String className, Map<String, String> properties, List<AuthConfigFactory.RegistrationContext> registrationContexts) {
        if (registrationContexts == null || registrationContexts.isEmpty()) {
            throw new IllegalArgumentException("Registration entry must contain one or more registration contexts");
        }
        this.className = className;
        this.properties = properties;
        this.registrationContexts = registrationContexts;
    }

    AuthConfigProviderEntry(String className, Map<String, String> properties, AuthConfigFactory.RegistrationContext registrationContext) {
        this.className = className;
        this.properties = properties;
        if (registrationContext != null) {
            this.registrationContexts = new ArrayList<RegistrationContextImpl>(Arrays.asList(new RegistrationContextImpl(registrationContext.getMessageLayer(), registrationContext.getAppContext(), registrationContext.getDescription(), registrationContext.isPersistent())));
        }
    }

    AuthConfigProviderEntry(AuthConfigProviderEntry other) {
        this.className = other.className;
        this.properties = other.properties;
        if (other.registrationContexts != null) {
            this.registrationContexts = new ArrayList<AuthConfigFactory.RegistrationContext>(other.registrationContexts);
        }
    }

    public boolean isConstructorEntry() {
        return this.registrationContexts == null;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<AuthConfigFactory.RegistrationContext> getRegistrationContexts() {
        return this.registrationContexts;
    }

    boolean matchConstructors(AuthConfigProviderEntry target) {
        if (target == null) {
            return false;
        }
        return !(this.isConstructorEntry() ^ target.isConstructorEntry()) && AuthConfigProviderEntry.matchStrings(this.className, target.getClassName()) && AuthConfigProviderEntry.matchMaps(this.properties, target.getProperties());
    }

    public static boolean matchStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean matchMaps(Map<String, String> map1, Map<String, String> map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        return map1.equals(map2);
    }
}

