/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.microprofile.health.service;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.microprofile.health.service.HealthServlet;

public class HealthServletInitializer
implements ServletContainerInitializer {
    private static final String MICROPROFILE_HEALTH_SERVLET = "microprofile-health-servlet";
    private static final String MICROPROFILE_HEALTH_ENABLED = "org.glassfish.microprofile.health.enabled";
    private static final Logger LOGGER = Logger.getLogger(HealthServletInitializer.class.getName());

    public void onStartup(Set<Class<?>> set, ServletContext servletContext) {
        if (!servletContext.getContextPath().isEmpty()) {
            return;
        }
        if (!Boolean.parseBoolean(System.getProperty(MICROPROFILE_HEALTH_ENABLED, "true"))) {
            LOGGER.info("MicroProfile Health is disabled");
            return;
        }
        servletContext.addServlet(MICROPROFILE_HEALTH_SERVLET, HealthServlet.class).addMapping(new String[]{"/health", "/health/live", "/health/ready", "/health/started"});
    }
}

