/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.cdi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.inject.Inject;
import jakarta.mvc.MvcContext;
import jakarta.mvc.event.AfterProcessViewEvent;
import jakarta.mvc.event.BeforeControllerEvent;
import jakarta.mvc.event.ControllerRedirectEvent;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.event.ControllerRedirectEventImpl;
import org.eclipse.krazo.jaxrs.JaxRsContext;
import org.eclipse.krazo.util.CdiUtils;
import org.eclipse.krazo.util.PropertyUtils;

@ApplicationScoped
public class RedirectScopeManager {
    public static final String DEFAULT_QUERY_PARAM_NAME = "org.eclipse.krazo.redirect.param.ScopeId";
    public static final String DEFAULT_COOKIE_NAME = "org.eclipse.krazo.redirect.Cookie";
    private static final String SCOPE_ID = "org.eclipse.krazo.redirect.attribute.ScopeId";
    private static final String INSTANCE = "Instance-";
    private static final String CREATIONAL = "Creational-";
    @Inject
    private HttpServletRequest request;
    @Inject
    @JaxRsContext
    private HttpServletResponse response;
    @Inject
    @JaxRsContext
    private Configuration config;
    @Inject
    private MvcContext mvc;
    @Inject
    private KrazoConfig krazoConfig;

    @PostConstruct
    public void init() {
        if (this.config == null || this.response == null || this.krazoConfig == null) {
            throw new IllegalStateException("It looks like @Context injection doesn't work for CDI beans. Please make sure you are using a recent version of Jersey.");
        }
    }

    public void destroy(Contextual contextual) {
        String scopeId = (String)this.request.getAttribute(SCOPE_ID);
        if (null != scopeId) {
            HttpSession session = this.request.getSession();
            if (!(contextual instanceof PassivationCapable)) {
                throw new RuntimeException("Unexpected type for contextual");
            }
            PassivationCapable pc = (PassivationCapable)contextual;
            String sessionKey = "org.eclipse.krazo.redirect.attribute.ScopeId-" + scopeId;
            Map scopeMap = (Map)session.getAttribute(sessionKey);
            if (null != scopeMap) {
                Object instance = scopeMap.get(INSTANCE + pc.getId());
                CreationalContext creational = (CreationalContext)scopeMap.get(CREATIONAL + pc.getId());
                if (null != instance && null != creational) {
                    contextual.destroy(instance, creational);
                    creational.release();
                }
            }
        }
    }

    public <T> T get(Contextual<T> contextual) {
        T result = null;
        String scopeId = (String)this.request.getAttribute(SCOPE_ID);
        if (null != scopeId) {
            HttpSession session = this.request.getSession();
            if (!(contextual instanceof PassivationCapable)) {
                throw new RuntimeException("Unexpected type for contextual");
            }
            PassivationCapable pc = (PassivationCapable)contextual;
            String sessionKey = "org.eclipse.krazo.redirect.attribute.ScopeId-" + scopeId;
            Map scopeMap = (Map)session.getAttribute(sessionKey);
            if (null != scopeMap) {
                result = (T)scopeMap.get(INSTANCE + pc.getId());
            } else {
                this.request.setAttribute(SCOPE_ID, null);
            }
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        Object result = this.get(contextual);
        if (result == null) {
            String scopeId = (String)this.request.getAttribute(SCOPE_ID);
            if (null == scopeId) {
                scopeId = this.generateScopeId();
            }
            HttpSession session = this.request.getSession();
            result = contextual.create(creational);
            if (!(contextual instanceof PassivationCapable)) {
                throw new RuntimeException("Unexpected type for contextual");
            }
            PassivationCapable pc = (PassivationCapable)contextual;
            String sessionKey = "org.eclipse.krazo.redirect.attribute.ScopeId-" + scopeId;
            Map scopeMap = (Map)session.getAttribute(sessionKey);
            if (null != scopeMap) {
                session.setAttribute(sessionKey, (Object)scopeMap);
                scopeMap.put(INSTANCE + pc.getId(), result);
                scopeMap.put(CREATIONAL + pc.getId(), creational);
            }
        }
        return result;
    }

    public void beforeProcessControllerEvent(@Observes BeforeControllerEvent event) {
        if (this.usingCookies()) {
            Cookie[] cookies = this.request.getCookies();
            if (null != cookies) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(this.krazoConfig.getRedirectScopeCookieName())) continue;
                    this.request.setAttribute(SCOPE_ID, (Object)cookie.getValue());
                    return;
                }
            }
        } else {
            String scopeId = (String)event.getUriInfo().getQueryParameters().getFirst((Object)this.krazoConfig.getRedirectScopeAttributeName());
            if (scopeId != null) {
                this.request.setAttribute(SCOPE_ID, (Object)scopeId);
            }
        }
    }

    public void afterProcessViewEvent(@Observes AfterProcessViewEvent event) {
        if (this.request.getAttribute(SCOPE_ID) != null) {
            String sessionKey;
            String scopeId = (String)this.request.getAttribute(SCOPE_ID);
            HttpSession session = this.request.getSession();
            Map scopeMap = (Map)session.getAttribute(sessionKey = "org.eclipse.krazo.redirect.attribute.ScopeId-" + scopeId);
            if (null != scopeMap) {
                scopeMap.entrySet().forEach(entrySet -> {
                    String key = (String)entrySet.getKey();
                    Object value = entrySet.getValue();
                    if (key.startsWith(INSTANCE)) {
                        BeanManager beanManager = CdiUtils.getApplicationBeanManager();
                        Bean bean = beanManager.resolve(beanManager.getBeans(value.getClass(), new Annotation[0]));
                        this.destroy((Contextual)bean);
                    }
                });
                scopeMap.clear();
                session.removeAttribute(sessionKey);
            }
        }
    }

    public void controllerRedirectEvent(@Observes ControllerRedirectEvent event) {
        if (this.request.getAttribute(SCOPE_ID) != null) {
            if (this.usingCookies()) {
                Cookie cookie = new Cookie(this.krazoConfig.getRedirectScopeCookieName(), this.request.getAttribute(SCOPE_ID).toString());
                cookie.setPath(this.request.getContextPath());
                cookie.setMaxAge(600);
                cookie.setHttpOnly(true);
                this.response.addCookie(cookie);
            } else {
                ContainerResponseContext crc = ((ControllerRedirectEventImpl)event).getContainerResponseContext();
                UriBuilder builder = UriBuilder.fromUri((String)((String)crc.getStringHeaders().getFirst((Object)"Location")));
                builder.queryParam(this.krazoConfig.getRedirectScopeAttributeName(), new Object[]{this.request.getAttribute(SCOPE_ID).toString()});
                crc.getHeaders().putSingle((Object)"Location", (Object)builder.build(new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateScopeId() {
        HttpSession session = this.request.getSession();
        String scopeId = UUID.randomUUID().toString();
        String sessionKey = "org.eclipse.krazo.redirect.attribute.ScopeId-" + scopeId;
        RedirectScopeManager redirectScopeManager = this;
        synchronized (redirectScopeManager) {
            while (session.getAttribute(sessionKey) != null) {
                scopeId = UUID.randomUUID().toString();
                sessionKey = "org.eclipse.krazo.redirect.attribute.ScopeId-" + scopeId;
            }
            session.setAttribute(sessionKey, new HashMap());
            this.request.setAttribute(SCOPE_ID, (Object)scopeId);
        }
        return scopeId;
    }

    private boolean usingCookies() {
        return PropertyUtils.getProperty(this.config, "org.eclipse.krazo.redirectScopeCookies", false);
    }
}

