/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.Renderer;
import java.io.IOException;

public class RbCbSelector
extends Selector
implements NamingContainer {
    public static final String IMAGE_FACET = "image";
    public static final String LABEL_FACET = "label";
    private static final Boolean TRUE_SELECTED_VALUE = Boolean.TRUE;
    private String imageURL = null;
    private Object items = null;
    private String name = null;

    public RbCbSelector() {
        this.setRendererType("com.sun.webui.jsf.RbCbSelectorRenderer");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.RbCbSelector";
    }

    protected void addToRequestMap(FacesContext context, String groupName) {
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String groupName = this.getName();
        if (groupName == null || !this.isValid() || !this.isChecked()) {
            return;
        }
        this.addToRequestMap(context, groupName);
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            return renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
        }
        return this.getConvertedValue(context, this, submittedValue);
    }

    public Object getConvertedValue(FacesContext context, RbCbSelector component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            throw new ConverterException("The submitted value is null. The submitted value must be a String or String array.");
        }
        boolean isStringArray = submittedValue instanceof String[];
        boolean isString = submittedValue instanceof String;
        if (!isStringArray && !isString) {
            throw new ConverterException("The submitted value must be a String or String array.");
        }
        String rawValue = null;
        if (isStringArray) {
            if (((String[])submittedValue).length > 0) {
                rawValue = ((String[])submittedValue)[0];
            }
        } else if (isString) {
            rawValue = (String)submittedValue;
        }
        boolean unselected = rawValue == null || rawValue.length() == 0;
        Object selectedValue = this.getSelectedValue();
        if (unselected) {
            Object newValue = ConversionUtilities.convertRenderedValue(context, rawValue, (UIComponent)this);
            if (!ConversionUtilities.renderedNull((UIComponent)component) && selectedValue instanceof Boolean && newValue == null) {
                newValue = (Boolean)selectedValue != false ? Boolean.FALSE : Boolean.TRUE;
            }
            return this.getUnselectedValue(context, (UIComponent)component, newValue);
        }
        Object newValue = ConversionUtilities.convertValueToObject((UIComponent)component, rawValue, context);
        if (newValue == rawValue) {
            return selectedValue;
        }
        return newValue;
    }

    private Object getUnselectedValue(FacesContext context, UIComponent component, Object noValue) {
        ValueExpression valueExpr = component.getValueExpression("value");
        if (valueExpr == null) {
            return noValue;
        }
        Class clazz = valueExpr.getType(context.getELContext());
        if (clazz == null) {
            return noValue;
        }
        if (clazz.isPrimitive()) {
            return this.getPrimitiveUnselectedValue(clazz, noValue);
        }
        return noValue;
    }

    private Object getPrimitiveUnselectedValue(Class clazz, Object booleanUnselectedValue) {
        if (clazz.equals(Boolean.TYPE)) {
            return booleanUnselectedValue;
        }
        if (clazz.equals(Byte.TYPE)) {
            return new Integer(-128);
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.MIN_VALUE;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.MIN_VALUE;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (clazz.equals(Short.TYPE)) {
            return (short)Short.MIN_VALUE;
        }
        return Long.MIN_VALUE;
    }

    public Object getSelectedValue() {
        Object sv = this.getItems();
        if (sv == null) {
            return TRUE_SELECTED_VALUE;
        }
        return sv;
    }

    public boolean isChecked() {
        Object selectedValue = this.getSelectedValue();
        Object selected = this.getSelected();
        if (selectedValue == null || selected == null) {
            return false;
        }
        if (this.getValueExpression("selected") == null && selected instanceof String && selectedValue instanceof Boolean) {
            return selectedValue.equals(Boolean.valueOf((String)selected));
        }
        return selected.equals(selectedValue);
    }

    public UIComponent getImageComponent() {
        UIComponent imageComponent = this.getFacet(IMAGE_FACET);
        if (imageComponent != null) {
            return imageComponent;
        }
        return this.createImageComponent();
    }

    public UIComponent getLabelComponent() {
        UIComponent labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent != null) {
            return labelComponent;
        }
        return this.createLabelComponent();
    }

    private UIComponent createLabelComponent() {
        String label = this.getLabel();
        if (label == null) {
            return null;
        }
        Label flabel = new Label();
        flabel.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, LABEL_FACET));
        flabel.setFor(this.getClientId(this.getFacesContext()));
        flabel.setText(label);
        flabel.setLabelLevel(this.getLabelLevel());
        flabel.setToolTip(this.getToolTip());
        flabel.setParent((UIComponent)this);
        return flabel;
    }

    private UIComponent createImageComponent() {
        String iurl = this.getImageURL();
        if (iurl == null) {
            return null;
        }
        ImageComponent image = new ImageComponent();
        image.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, IMAGE_FACET));
        image.setUrl(this.getImageURL());
        image.setToolTip(this.getToolTip());
        image.setAlt(this.getToolTip());
        image.setParent((UIComponent)this);
        return image;
    }

    @Override
    public ValueExpression getValueExpression(String exprName) {
        if (exprName.equals("selected")) {
            return super.getValueExpression("value");
        }
        if (exprName.equals("selectedValue")) {
            return super.getValueExpression("items");
        }
        return super.getValueExpression(exprName);
    }

    @Override
    public void setValueExpression(String exprName, ValueExpression binding) {
        if (exprName.equals("selected")) {
            super.setValueExpression("value", binding);
            return;
        }
        if (exprName.equals("selectedValue")) {
            super.setValueExpression("items", binding);
            return;
        }
        super.setValueExpression(exprName, binding);
    }

    public String getImageURL() {
        if (this.imageURL != null) {
            return this.imageURL;
        }
        ValueExpression vb = this.getValueExpression("imageURL");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setImageURL(String newImageURL) {
        this.imageURL = newImageURL;
    }

    @Override
    public Object getItems() {
        if (this.items != null) {
            return this.items;
        }
        ValueExpression vb = this.getValueExpression("items");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setItems(Object newItems) {
        this.items = newItems;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        ValueExpression vb = this.getValueExpression("name");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public Object getSelected() {
        return this.getValue();
    }

    @Override
    public void setSelected(Object selected) {
        this.setValue(selected);
    }

    public void setSelectedValue(Object selectedValue) {
        this.setItems(selectedValue);
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.imageURL = (String)values[1];
        this.items = values[2];
        this.name = (String)values[3];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.imageURL, this.items, this.name};
        return values;
    }
}

