/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.event;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.kernel.event.EventsImpl;
import org.glassfish.kernel.event.OSGiAwareEventsImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class EventsFactory
implements Factory<Events> {
    private static final String BUNDLE_REFERENCE_CLASS_NAME = "org.osgi.framework.BundleReference";
    @Inject
    private ServiceLocator serviceLocator;

    @Singleton
    public Events provide() {
        if (this.isOSGiEnv()) {
            return (Events)this.serviceLocator.createAndInitialize(OSGiAwareEventsImpl.class);
        }
        return (Events)this.serviceLocator.createAndInitialize(EventsImpl.class);
    }

    public void dispose(Events events) {
        this.serviceLocator.preDestroy((Object)events);
    }

    private boolean isOSGiEnv() {
        return this.isBundleReference(this.getClass().getClassLoader());
    }

    private boolean isBundleReference(Object obj) {
        ArrayDeque interfaces = new ArrayDeque();
        for (Class<?> c = obj.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            interfaces.addAll(Arrays.asList(c.getInterfaces()));
            while (!interfaces.isEmpty()) {
                Class interfaceClass = (Class)interfaces.poll();
                if (BUNDLE_REFERENCE_CLASS_NAME.equals(interfaceClass.getName())) {
                    return true;
                }
                interfaces.addAll(Arrays.asList(interfaceClass.getInterfaces()));
            }
        }
        return false;
    }
}

