/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivistFor;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.ejb.deployment.annotation.impl.EjbInWarScanner;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.io.EjbDeploymentDescriptorFile;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ExtensionsArchivistFor(value="ejb")
public class EjbInWarArchivist
extends ExtensionsArchivist {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    Provider<EjbInWarScanner> scanner;

    public DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor descriptor) {
        if (this.standardDD == null) {
            this.standardDD = new EjbDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles(RootDeploymentDescriptor descriptor) {
        if (this.confDDFiles == null) {
            this.confDDFiles = DOLUtils.getConfigurationDeploymentDescriptorFiles((ServiceLocator)this.serviceLocator, (String)"ejb");
        }
        return this.confDDFiles;
    }

    public ModuleScanner getScanner() {
        return (ModuleScanner)this.scanner.get();
    }

    public boolean supportsModuleType(ArchiveType moduleType) {
        return DOLUtils.warType().equals((Object)moduleType) || DOLUtils.scatteredWarType().equals((Object)moduleType);
    }

    public RootDeploymentDescriptor getDefaultDescriptor() {
        return new EjbBundleDescriptorImpl();
    }

    public void writeDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, ReadableArchive in, WritableArchive out) throws IOException {
        Collection ejbExtensions = descriptor.getExtensionsDescriptors(EjbBundleDescriptorImpl.class);
        for (EjbBundleDescriptorImpl ejbBundle : ejbExtensions) {
            super.writeDeploymentDescriptors(main, (BundleDescriptor)ejbBundle, in, out);
        }
    }
}

