/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedData;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.c14n.StAXAttr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class EncryptedContentHeaderParser {
    XMLStreamReader encContentReader = null;
    boolean parsed = false;
    String localName;
    String uri;
    String prefix;
    Vector attrList = new Vector();
    Vector attrNSList = new Vector();
    EncryptedData ed = null;
    private HashMap<String, String> parentNS = null;
    private JAXBFilterProcessingContext context = null;

    EncryptedContentHeaderParser(XMLStreamReader encContentReader, HashMap<String, String> parentNS, JAXBFilterProcessingContext context) {
        this.encContentReader = encContentReader;
        this.parentNS = parentNS;
        this.context = context;
    }

    XMLStreamReader getDecryptedElement(InputStream decryptedIS) throws XMLStreamException, XWSSecurityException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out);
        this.writeStartElement(writer);
        this.writeEndElement(writer);
        writer.flush();
        writer.close();
        try {
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
        String outStr = out.toString();
        int pos = outStr.indexOf(62);
        String startElem = outStr.substring(0, pos + 1);
        String endElem = outStr.substring(pos + 1);
        try {
            tmpOut.write(startElem.getBytes());
            byte[] buf = new byte[4096];
            int len = -1;
            while ((len = decryptedIS.read(buf)) != -1) {
                tmpOut.write(buf, 0, len);
            }
            tmpOut.write(endElem.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ByteArrayInputStream finalContent = new ByteArrayInputStream(tmpOut.toByteArray());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        return xif.createXMLStreamReader(finalContent);
    }

    void writeStartElement(XMLStreamWriter xsw) throws XMLStreamException, XWSSecurityException {
        StAXAttr attr;
        int i;
        if (!this.parsed) {
            this.parse();
        }
        xsw.writeStartElement(this.prefix, this.localName, this.uri);
        if (this.parentNS.containsKey(this.prefix)) {
            xsw.writeNamespace(this.prefix, this.uri);
        }
        for (i = 0; i < this.attrNSList.size(); ++i) {
            AttributeNS attrNs = (AttributeNS)this.attrNSList.get(i);
            xsw.writeNamespace(attrNs.getPrefix(), attrNs.getUri());
        }
        for (i = 0; i < this.attrList.size(); ++i) {
            attr = (StAXAttr)this.attrList.get(i);
            if (!this.parentNS.containsKey(attr.getPrefix())) continue;
            xsw.writeNamespace(attr.getPrefix(), this.parentNS.get(attr.getPrefix()));
        }
        for (i = 0; i < this.attrList.size(); ++i) {
            attr = (StAXAttr)this.attrList.get(i);
            xsw.writeAttribute(attr.getPrefix(), attr.getUri(), attr.getLocalName(), attr.getValue());
        }
    }

    void writeEndElement(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
    }

    EncryptedData getEncryptedData() throws XMLStreamException, XWSSecurityException {
        if (!this.parsed) {
            this.parse();
        }
        return this.ed;
    }

    void parse() throws XMLStreamException, XWSSecurityException {
        this.parsed = true;
        boolean stop = false;
        boolean parentElem = true;
        while (this.encContentReader.hasNext()) {
            int eventType = 1;
            if (!parentElem) {
                eventType = this.encContentReader.next();
            }
            if (stop) {
                return;
            }
            switch (eventType) {
                case 1: {
                    if (parentElem) {
                        String uri;
                        int i;
                        this.localName = this.encContentReader.getLocalName();
                        this.uri = this.encContentReader.getNamespaceURI();
                        this.prefix = this.encContentReader.getPrefix();
                        if (this.prefix == null) {
                            this.prefix = "";
                        }
                        int count = this.encContentReader.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            String localName = this.encContentReader.getAttributeLocalName(i);
                            uri = this.encContentReader.getAttributeNamespace(i);
                            String prefix = this.encContentReader.getAttributePrefix(i);
                            if (prefix == null) {
                                prefix = "";
                            }
                            String value = this.encContentReader.getAttributeValue(i);
                            StAXAttr attr = new StAXAttr();
                            attr.setLocalName(localName);
                            attr.setValue(value);
                            attr.setPrefix(prefix);
                            attr.setUri(uri);
                            this.attrList.add(attr);
                        }
                        count = 0;
                        count = this.encContentReader.getNamespaceCount();
                        for (i = 0; i < count; ++i) {
                            String prefix = this.encContentReader.getNamespacePrefix(i);
                            if (prefix == null) {
                                prefix = "";
                            }
                            uri = this.encContentReader.getNamespaceURI(i);
                            AttributeNS attrNS = new AttributeNS();
                            attrNS.setPrefix(prefix);
                            attrNS.setUri(uri);
                            this.attrNSList.add(attrNS);
                        }
                        parentElem = false;
                        break;
                    }
                    if (this.encContentReader.getLocalName() != "EncryptedData" || this.encContentReader.getNamespaceURI() != "http://www.w3.org/2001/04/xmlenc#") break;
                    this.ed = new EncryptedData(this.encContentReader, this.context, this.parentNS);
                    break;
                }
                case 2: {
                    stop = true;
                }
            }
        }
    }
}

