/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveEntryWrapper;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveMember;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveMemberHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstitutionFileUtil;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Archive;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.MemberEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class ArchiveEntryWrapperImpl
implements ArchiveEntryWrapper {
    private static final System.Logger LOG = System.getLogger(ArchiveEntryWrapperImpl.class.getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(ArchiveEntryWrapperImpl.class);
    private static final String EXTRACTION_DIR_PREFIX = "ext";
    private static final byte[] _buffer = new byte[10000];
    private Archive _archive;
    private ArchiveEntryWrapperImpl _parent = null;
    private File _extractDir = null;
    private JarFile _jar = null;
    private List<ArchiveMember> _allArchiveMembers;
    private Map<String, File> _extractedEntries = new HashMap<String, File>();
    private AtomicInteger _noOfExtractedEntries = new AtomicInteger();

    ArchiveEntryWrapperImpl(Archive archive) throws IOException {
        this(archive, null, null);
    }

    private ArchiveEntryWrapperImpl(Archive archive, String archivePath, ArchiveEntryWrapperImpl parent) throws IOException {
        this._archive = archive;
        this._jar = archivePath == null || archivePath.isEmpty() ? new JarFile(this._archive.getName()) : new JarFile(archivePath + this._archive.getName());
        this._parent = parent;
        this._extractDir = SubstitutionFileUtil.setupDir(EXTRACTION_DIR_PREFIX);
        this.extract();
    }

    @Override
    public ArchiveEntryWrapper getParentArchive() {
        return this._parent;
    }

    @Override
    public List<? extends ArchiveMember> getSubstitutables() {
        return this._allArchiveMembers == null ? new ArrayList(1) : this._allArchiveMembers;
    }

    @Override
    public void notifyCompletion() {
        if (this._noOfExtractedEntries.decrementAndGet() <= 0) {
            try {
                this.updateArchive();
                SubstitutionFileUtil.removeDir(this._extractDir);
                if (this._parent != null) {
                    this._parent.notifyCompletion();
                }
            }
            catch (IOException e) {
                SubstitutionFileUtil.removeDir(this._extractDir);
                LOG.log(System.Logger.Level.WARNING, () -> "Failed to update jar " + this._archive.getName() + " with the substitutable files", (Throwable)e);
            }
        }
    }

    private void extract() throws IOException {
        for (Object object : this._archive.getArchiveOrMemberEntry()) {
            File file;
            String extratFilePath = this._extractDir.getAbsolutePath() + File.separator;
            if (object instanceof Archive) {
                Archive archive = (Archive)object;
                file = new File(extratFilePath + archive.getName());
                try {
                    this.extractEntry(archive.getName(), file);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                this._extractedEntries.put(archive.getName(), file);
                new ArchiveEntryWrapperImpl(archive, extratFilePath, this);
                this._noOfExtractedEntries.incrementAndGet();
                continue;
            }
            if (object instanceof MemberEntry) {
                MemberEntry entry = (MemberEntry)object;
                file = new File(extratFilePath + entry.getName());
                try {
                    this.extractEntry(entry.getName(), file);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                this._extractedEntries.put(entry.getName(), file);
                this.getAllArchiveMemberList().add(new ArchiveMemberHandler(file, this));
                this._noOfExtractedEntries.incrementAndGet();
                continue;
            }
            LOG.log(System.Logger.Level.WARNING, () -> "File " + String.valueOf(object) + " not present inside archive " + this._archive.getName());
        }
    }

    private List<ArchiveMember> getAllArchiveMemberList() {
        ArchiveEntryWrapperImpl current = this;
        while (current._parent != null) {
            current = current._parent;
        }
        if (current._allArchiveMembers == null) {
            current._allArchiveMembers = new ArrayList<ArchiveMember>();
        }
        return current._allArchiveMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry(String name, File file) throws IOException, IllegalArgumentException {
        FilterOutputStream outputStream;
        block19: {
            if (this._jar == null) {
                throw new JarException("Jar file is closed.");
            }
            JarEntry jarEntry = this._jar.getJarEntry(name);
            if (jarEntry == null) {
                String msg = _strings.get("invalidArchiveEntry", new Object[]{name, this._jar.getName()});
                throw new IllegalArgumentException(msg);
            }
            if (jarEntry.isDirectory() && !file.exists()) {
                if (!file.mkdirs()) {
                    LOG.log(System.Logger.Level.INFO, () -> "Could not create directory " + file.getAbsolutePath());
                }
                return;
            }
            InputStream in = null;
            outputStream = null;
            try {
                in = this._jar.getInputStream(jarEntry);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                int i = 0;
                while ((i = in.read(_buffer)) != -1) {
                    ((BufferedOutputStream)outputStream).write(_buffer, 0, i);
                }
                if (in == null) break block19;
            }
            catch (Throwable throwable) {
                block21: {
                    block20: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block20;
                                LOG.log(System.Logger.Level.DEBUG, _strings.get("errorInClosingStream", new Object[]{this._jar.getName()}), (Throwable)e);
                            }
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block21;
                            LOG.log(System.Logger.Level.DEBUG, _strings.get("errorInClosingStream", new Object[]{file.getPath()}), (Throwable)e);
                        }
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block19;
                LOG.log(System.Logger.Level.DEBUG, _strings.get("errorInClosingStream", new Object[]{this._jar.getName()}), (Throwable)e);
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                    LOG.log(System.Logger.Level.DEBUG, _strings.get("errorInClosingStream", new Object[]{file.getPath()}), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void updateArchive() throws IOException {
        block46: {
            File tempJarFile;
            File jarFile;
            boolean success;
            block43: {
                if (this._extractedEntries.isEmpty()) {
                    LOG.log(System.Logger.Level.DEBUG, () -> _strings.get("noArchiveEntryToUpdate", new Object[]{this._archive.getName()}));
                    return;
                }
                if (this._jar == null) {
                    throw new JarException("Jar file is not in open state, jar path.");
                }
                success = false;
                jarFile = new File(this._jar.getName());
                tempJarFile = File.createTempFile("helper", ".jar", jarFile.getParentFile());
                try (FileOutputStream fos = new FileOutputStream(tempJarFile);
                     JarOutputStream jos = new JarOutputStream(fos);){
                    InputStream is = null;
                    Set<String> extractedJarEntries = this._extractedEntries.keySet();
                    Enumeration<JarEntry> e = this._jar.entries();
                    while (e.hasMoreElements()) {
                        String jarEntryName = e.nextElement().getName();
                        if (extractedJarEntries.contains(jarEntryName)) {
                            File file = this._extractedEntries.get(jarEntryName);
                            if (file == null) continue;
                            JarEntry entry = new JarEntry(jarEntryName);
                            is = new FileInputStream(file);
                            this.appendEntry(jos, entry, is);
                            continue;
                        }
                        JarEntry je = this._jar.getJarEntry(jarEntryName);
                        is = this._jar.getInputStream(je);
                        this.appendEntry(jos, je, is);
                    }
                    success = true;
                }
                try {
                    this._jar.close();
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block43;
                    LOG.log(System.Logger.Level.DEBUG, "Problem occurred while closing the jar file : " + jarFile.getPath(), (Throwable)e);
                }
            }
            if (!jarFile.delete()) {
                if (!tempJarFile.delete()) {
                    LOG.log(System.Logger.Level.ERROR, "Error occurred while closing the stream for file {0}", tempJarFile.getAbsolutePath());
                }
                throw new IOException(jarFile.getPath() + " did not get updated. Unable to delete.");
            }
            if (!success) {
                if (!tempJarFile.delete()) {
                    LOG.log(System.Logger.Level.INFO, () -> _strings.get("errorInClosingStream", new Object[]{tempJarFile.getAbsolutePath()}));
                }
            } else if (!tempJarFile.renameTo(jarFile)) {
                LOG.log(System.Logger.Level.ERROR, () -> "Could not rename temporary jar " + tempJarFile.getName() + " file to " + jarFile.getName());
            }
            break block46;
            catch (Exception e) {
                block44: {
                    try {
                        LOG.log(System.Logger.Level.ERROR, "Error occurred while closing the stream for file " + this._archive.getName(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        block45: {
                            try {
                                this._jar.close();
                            }
                            catch (IOException e2) {
                                if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block45;
                                LOG.log(System.Logger.Level.DEBUG, "Problem occurred while closing the jar file : " + jarFile.getPath(), (Throwable)e2);
                            }
                        }
                        if (!jarFile.delete()) {
                            if (!tempJarFile.delete()) {
                                LOG.log(System.Logger.Level.ERROR, "Error occurred while closing the stream for file {0}", tempJarFile.getAbsolutePath());
                            }
                            throw new IOException(jarFile.getPath() + " did not get updated. Unable to delete.");
                        }
                        if (!success) {
                            if (!tempJarFile.delete()) {
                                LOG.log(System.Logger.Level.INFO, () -> _strings.get("errorInClosingStream", new Object[]{tempJarFile.getAbsolutePath()}));
                            }
                        } else if (!tempJarFile.renameTo(jarFile)) {
                            LOG.log(System.Logger.Level.ERROR, () -> "Could not rename temporary jar " + tempJarFile.getName() + " file to " + jarFile.getName());
                        }
                        throw throwable;
                    }
                    try {
                        this._jar.close();
                    }
                    catch (IOException e3) {
                        if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block44;
                        LOG.log(System.Logger.Level.DEBUG, "Problem occurred while closing the jar file : " + jarFile.getPath(), (Throwable)e3);
                    }
                }
                if (!jarFile.delete()) {
                    if (!tempJarFile.delete()) {
                        LOG.log(System.Logger.Level.ERROR, "Error occurred while closing the stream for file {0}", tempJarFile.getAbsolutePath());
                    }
                    throw new IOException(jarFile.getPath() + " did not get updated. Unable to delete.");
                }
                if (!success) {
                    if (!tempJarFile.delete()) {
                        LOG.log(System.Logger.Level.INFO, () -> _strings.get("errorInClosingStream", new Object[]{tempJarFile.getAbsolutePath()}));
                    }
                } else if (!tempJarFile.renameTo(jarFile)) {
                    LOG.log(System.Logger.Level.ERROR, () -> "Could not rename temporary jar " + tempJarFile.getName() + " file to " + jarFile.getName());
                }
            }
        }
    }

    private void appendEntry(JarOutputStream jos, JarEntry jarEntry, InputStream is) throws IOException {
        jos.putNextEntry(jarEntry);
        if (!jarEntry.isDirectory()) {
            int i = 0;
            while ((i = is.read(_buffer)) != -1) {
                jos.write(_buffer, 0, i);
            }
            is.close();
            jos.flush();
        }
        jos.closeEntry();
    }
}

