/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.theme.JarTheme;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeConfigurationException;
import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeFactory;
import com.sun.webui.theme.ThemeManager;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class JarThemeFactory
implements ThemeFactory {
    private static final String WARNING_LOAD = "WARNING: the Sun Web Components could not load any themes.";
    private static final boolean DEBUG = false;
    private ThemeManager themeManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getThemeAttributes(ClassLoader classLoader) {
        Collection<URL> manifests = JarThemeFactory.getManifests(classLoader);
        if (manifests.isEmpty()) {
            String msg = "No Themes in the classpath!";
            throw new ThemeConfigurationException(msg);
        }
        InputStream in = null;
        ArrayList<Attributes> themeProps = new ArrayList<Attributes>();
        for (URL url : manifests) {
            try {
                URLConnection conn = url.openConnection();
                in = conn.getInputStream();
                Manifest manifest = new Manifest(in);
                Attributes themeAttributes = manifest.getAttributes("com/sun/webui/jsf/theme/");
                if (themeAttributes == null) continue;
                themeAttributes.putValue("manifest-file", url.toString());
                themeProps.add(themeAttributes);
            }
            catch (IOException iOException) {}
            continue;
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return themeProps.iterator();
    }

    private String readAttribute(Attributes themeAttributes, String propName) {
        String name = themeAttributes.getValue(propName);
        if (name == null || name.length() == 0) {
            String propFile = themeAttributes.getValue("manifest-file");
            StringBuilder msgBuffer = new StringBuilder();
            msgBuffer.append("ThemeConfiguration file ");
            if (propFile != null) {
                msgBuffer.append(propFile);
                msgBuffer.append(" ");
            }
            msgBuffer.append("does not contain required property \"");
            msgBuffer.append(propName);
            msgBuffer.append("\".");
            throw new ThemeConfigurationException(msgBuffer.toString());
        }
        return name;
    }

    private void throwVersionException(String name, String version, String requiredThemeVersion) {
        StringBuilder msgBuffer = new StringBuilder();
        msgBuffer.append("\n\nTheme \"");
        msgBuffer.append(name);
        msgBuffer.append("\" is not up to date with the component library.\n");
        msgBuffer.append("Its version is ");
        msgBuffer.append(version);
        msgBuffer.append(". Version ");
        msgBuffer.append(requiredThemeVersion);
        msgBuffer.append(" or higher required.\n");
        throw new ThemeConfigurationException(msgBuffer.toString());
    }

    private static Set<Locale> getLocales(Application application) {
        Iterator localeIterator;
        HashSet<Locale> localeSet = new HashSet<Locale>();
        Locale locale = application.getDefaultLocale();
        if (locale != null) {
            localeSet.add(locale);
        }
        if ((localeIterator = application.getSupportedLocales()) != null) {
            while (localeIterator.hasNext()) {
                Locale localeObject = (Locale)localeIterator.next();
                localeSet.add(localeObject);
            }
        }
        if (localeSet.isEmpty()) {
            localeSet.add(Locale.getDefault());
        }
        return localeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRequiredThemeVersion(ClassLoader classLoader) {
        Collection<URL> manifests = JarThemeFactory.getManifests(classLoader);
        if (manifests.isEmpty()) {
            return null;
        }
        InputStream in = null;
        String themeVersion = null;
        Iterator<URL> it = manifests.iterator();
        while (themeVersion == null && it.hasNext()) {
            URL url = it.next();
            if (!url.toString().contains("webui")) continue;
            try {
                in = url.openConnection().getInputStream();
                Manifest manifest = new Manifest(in);
                Attributes attr = manifest.getAttributes("com/sun/webui/jsf/");
                if (attr == null) continue;
                themeVersion = attr.getValue("X-SJWUIC-Theme-Version-Required");
            }
            catch (IOException ex) {
                LogUtil.severe(null, ex);
            }
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return themeVersion;
    }

    private static Collection<URL> getManifests(ClassLoader classLoader) {
        if (classLoader == null) {
            return Collections.emptyList();
        }
        Enumeration<URL> manifests = null;
        if (Beans.isDesignTime() && classLoader instanceof URLClassLoader) {
            URL[] urls;
            HashSet<URL> v = new HashSet<URL>();
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                try {
                    URL manifest = new URL(url, "META-INF/MANIFEST.MF");
                    InputStream is = manifest.openStream();
                    v.add(manifest);
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return v;
        }
        try {
            manifests = classLoader.getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (manifests == null) {
            return Collections.emptyList();
        }
        if (!manifests.hasMoreElements()) {
            try {
                manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (manifests == null) {
                return Collections.emptyList();
            }
        }
        return Collections.list(manifests);
    }

    private static void log(String msg) {
        LogUtil.finest(JarThemeFactory.class.getName() + "::" + msg);
    }

    @Override
    public Theme getTheme(Locale locale, ThemeContext themeContext) {
        return this.getTheme(null, locale, themeContext);
    }

    @Override
    public Theme getTheme(String themeName, Locale locale, ThemeContext themeContext) {
        if (this.themeManager == null) {
            this.themeManager = this.createThemeManager(themeContext);
        }
        JarTheme theme = this.themeManager.getTheme(themeName, locale);
        theme.setThemeContext(themeContext);
        return theme;
    }

    @Override
    public String getDefaultThemeName(ThemeContext themeContext) {
        if (this.themeManager == null) {
            this.themeManager = this.createThemeManager(themeContext);
        }
        return this.themeManager.getDefaultThemeName();
    }

    private ThemeManager createThemeManager(ThemeContext themeContext) {
        String defaultThemeName = themeContext.getDefaultTheme();
        String name = null;
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        String requiredThemeVersion = JarThemeFactory.getRequiredThemeVersion(classLoader);
        Iterator themeAttributesIterator = this.getThemeAttributes(classLoader);
        if (!themeAttributesIterator.hasNext()) {
            throw new ThemeConfigurationException(WARNING_LOAD);
        }
        ThemeManager manager = new ThemeManager();
        while (themeAttributesIterator.hasNext()) {
            String isDefault;
            FacesContext ctx;
            Attributes themeAttributes = (Attributes)themeAttributesIterator.next();
            name = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-Name");
            String version = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-Version");
            if (requiredThemeVersion != null && requiredThemeVersion.compareTo(version) > 0) {
                this.throwVersionException(name, version, requiredThemeVersion);
            }
            HashMap<Locale, Theme> map = new HashMap<Locale, Theme>();
            Set<Locale> localeSet = themeContext.getSupportedLocales();
            if (localeSet == null && (ctx = FacesContext.getCurrentInstance()) != null) {
                localeSet = JarThemeFactory.getLocales(ctx.getApplication());
            }
            if (localeSet == null) {
                localeSet = new HashSet<Locale>();
                localeSet.add(themeContext.getDefaultLocale());
            }
            for (Locale locale : localeSet) {
                map.put(locale, this.createTheme(themeAttributes, locale, themeContext));
            }
            manager.addThemeMap(name, map);
            if (defaultThemeName != null || (isDefault = themeAttributes.getValue("X-SJWUIC-Theme-Default")) == null || !isDefault.toLowerCase().equals("true")) continue;
            defaultThemeName = name;
        }
        manager.setDefaultThemeName(defaultThemeName);
        return manager;
    }

    private Theme createTheme(Attributes themeAttributes, Locale locale, ThemeContext themeContext) throws ThemeConfigurationException {
        if (themeContext.getThemeServletContext() == null) {
            String prefix = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-Prefix");
            if (!prefix.startsWith("/")) {
                prefix = "/".concat(prefix);
            }
            themeContext.setThemeServletContext(prefix);
        }
        JarTheme theme = new JarTheme(locale);
        ResourceBundle override = null;
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        ResourceBundle bundle = this.createResourceBundle(themeAttributes, "X-SJWUIC-Theme-Messages", locale, classLoader);
        String messageOverride = themeContext.getMessages();
        if (messageOverride != null) {
            try {
                override = ResourceBundle.getBundle(messageOverride, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        theme.configureMessages(bundle, override);
        bundle = this.createResourceBundle(themeAttributes, "X-SJWUIC-Theme-Images", locale, classLoader);
        theme.configureImages(bundle);
        bundle = this.createResourceBundle(themeAttributes, "X-SJWUIC-Theme-JavaScript", locale, classLoader);
        String jsFiles = this.readAttribute(themeAttributes, "X-SJWUIC-Theme-JavaScript");
        theme.configureJSFiles(bundle);
        bundle = this.createResourceBundle(themeAttributes, "X-SJWUIC-Theme-Stylesheets", locale, classLoader);
        theme.configureStylesheets(bundle);
        bundle = this.createResourceBundle(themeAttributes, "X-SJWUIC-Theme-Templates", locale, classLoader);
        theme.configureTemplates(bundle);
        String classMapper = themeAttributes.getValue("X-SJWUIC-Theme-ClassMapper");
        if (classMapper != null && classMapper.length() > 0) {
            bundle = this.createResourceBundle(themeAttributes, "X-SJWUIC-Theme-ClassMapper", locale, classLoader);
            theme.configureClassMapper(bundle);
        }
        return theme;
    }

    private ResourceBundle createResourceBundle(Attributes themeAttributes, String propName, Locale locale, ClassLoader classLoader) {
        String bundleName = this.readAttribute(themeAttributes, propName);
        try {
            return ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        catch (MissingResourceException mre) {
            StringBuilder msgBuffer = new StringBuilder();
            msgBuffer.append("Invalid theme configuration file for theme ");
            msgBuffer.append(themeAttributes.getValue("X-SJWUIC-Theme-Name"));
            msgBuffer.append(".\nJarThemeFactory could not locate resource bundle at ");
            msgBuffer.append(bundleName);
            msgBuffer.append(".");
            throw new ThemeConfigurationException(msgBuffer.toString());
        }
    }
}

