/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Legend;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public final class LegendRenderer
extends AbstractRenderer {
    private static final String DEFAULT_POSITION = "right";

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null || writer == null) {
            throw new NullPointerException();
        }
        Legend legend = (Legend)component;
        if (!legend.isRendered()) {
            return;
        }
        this.renderOuterDiv(context, legend, writer);
        RenderingUtilities.renderComponent(legend.getLegendImage(), context);
        writer.write("&nbsp;");
        String text = legend.getText() != null ? legend.getText() : this.getTheme().getMessage("Legend.requiredField");
        writer.writeText((Object)text, null);
        writer.endElement("div");
    }

    protected void renderOuterDiv(FacesContext context, Legend legend, ResponseWriter writer) throws IOException {
        String style = legend.getStyle();
        String id = legend.getClientId(context);
        String divStyleClass = this.getTheme().getStyleClass("LABEL_REQUIRED_DIV");
        String align = legend.getPosition() != null ? legend.getPosition() : DEFAULT_POSITION;
        writer.startElement("div", (UIComponent)legend);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("align", (Object)align, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)legend, divStyleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }
}

