/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;

public abstract class DatabaseValueHolder<T>
implements WeavedAttributeValueHolderInterface<T>,
Cloneable,
Serializable {
    protected volatile T value;
    protected volatile boolean isInstantiated;
    protected transient AbstractSession session;
    protected AbstractRecord row;
    protected boolean isCoordinatedWithProperty = false;

    protected DatabaseValueHolder() {
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError();
        }
    }

    public AbstractRecord getRow() {
        return this.row;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public ValueHolderInterface<?> getWrappedValueHolder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getValue() {
        boolean instantiated = this.isInstantiated;
        if (!instantiated) {
            DatabaseValueHolder databaseValueHolder = this;
            synchronized (databaseValueHolder) {
                instantiated = this.isInstantiated;
                if (!instantiated) {
                    this.privilegedSetValue(this.instantiate());
                    this.isInstantiated = true;
                    this.postInstantiate();
                    this.resetFields();
                }
            }
        }
        return this.value;
    }

    public T getValue(UnitOfWorkImpl uow) {
        return null;
    }

    protected abstract T instantiate() throws DatabaseException;

    public abstract T instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder<T> var1);

    @Override
    public boolean isCoordinatedWithProperty() {
        return this.isCoordinatedWithProperty;
    }

    @Override
    public boolean isNewlyWeavedValueHolder() {
        return false;
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated;
    }

    @Override
    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public abstract boolean isPessimisticLockingValueHolder();

    protected boolean isTransactionalValueHolder() {
        return this.session != null && this.session.isUnitOfWork();
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return false;
    }

    public void postInstantiate() {
    }

    public void privilegedSetValue(T value) {
        this.value = value;
        this.isCoordinatedWithProperty = false;
    }

    public void releaseWrappedValueHolder(AbstractSession targetSession) {
        AbstractSession session = this.session;
        if (session != null && session.isUnitOfWork()) {
            this.session = targetSession;
        }
    }

    protected void resetFields() {
        this.row = null;
        this.session = null;
    }

    @Override
    public void setIsCoordinatedWithProperty(boolean coordinated) {
        this.isCoordinatedWithProperty = coordinated;
    }

    @Override
    public void setIsNewlyWeavedValueHolder(boolean isNew) {
    }

    public void setInstantiated() {
        this.isInstantiated = true;
    }

    public void setRow(AbstractRecord row) {
        this.row = row;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setUninstantiated() {
        this.isInstantiated = false;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.setInstantiated();
    }

    @Override
    public boolean shouldAllowInstantiationDeferral() {
        return true;
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + String.valueOf(this.getValue()) + "}";
        }
        return "{" + this.getClass().getSimpleName() + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }
}

