/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Cache<K, V> {
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private final Factory<K, V> factory;

    public Cache(Factory<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        Objects.requireNonNull(key);
        return this.cache.computeIfAbsent(key, this.factory);
    }

    public V remove(K key) {
        return this.cache.remove(key);
    }

    public static interface Factory<K, V>
    extends Function<K, V> {
        public V newInstance(K var1) throws InterruptedException;

        @Override
        default public V apply(K key) {
            try {
                return this.newInstance(key);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

