/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.interception.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.glassfish.hk2.extras.interception.InterceptionBinder;

public class ReflectionUtilities {
    public static HashSet<String> getAllBindingsFromMethod(Method m) {
        Annotation[] allMethodAnnotations;
        HashSet<String> retVal = ReflectionUtilities.getAllBindingsFromClass(m.getDeclaringClass());
        for (Annotation aMethodAnnotation : allMethodAnnotations = m.getAnnotations()) {
            if (!ReflectionUtilities.isBindingAnnotation(aMethodAnnotation)) continue;
            ReflectionUtilities.getAllBinderAnnotations(aMethodAnnotation, retVal);
        }
        return retVal;
    }

    public static HashSet<String> getAllBindingsFromConstructor(Constructor<?> m) {
        Annotation[] allMethodAnnotations;
        HashSet<String> retVal = ReflectionUtilities.getAllBindingsFromClass(m.getDeclaringClass());
        for (Annotation aMethodAnnotation : allMethodAnnotations = m.getAnnotations()) {
            if (!ReflectionUtilities.isBindingAnnotation(aMethodAnnotation)) continue;
            ReflectionUtilities.getAllBinderAnnotations(aMethodAnnotation, retVal);
        }
        return retVal;
    }

    public static HashSet<String> getAllBindingsFromClass(Class<?> c) {
        Annotation[] allClassAnnotations;
        HashSet<String> retVal = new HashSet<String>();
        for (Annotation aClassAnnotation : allClassAnnotations = c.getAnnotations()) {
            if (!ReflectionUtilities.isBindingAnnotation(aClassAnnotation)) continue;
            ReflectionUtilities.getAllBinderAnnotations(aClassAnnotation, retVal);
        }
        return retVal;
    }

    private static boolean isBindingAnnotation(Annotation a) {
        return a.annotationType().getAnnotation(InterceptionBinder.class) != null;
    }

    private static void getAllBinderAnnotations(Annotation a, HashSet<String> retVal) {
        Annotation[] subAnnotations;
        String aName = a.annotationType().getName();
        if (retVal.contains(aName)) {
            return;
        }
        retVal.add(aName);
        for (Annotation subAnnotation : subAnnotations = a.annotationType().getAnnotations()) {
            String subName;
            if (!ReflectionUtilities.isBindingAnnotation(subAnnotation) || retVal.contains(subName = subAnnotation.annotationType().getName())) continue;
            ReflectionUtilities.getAllBinderAnnotations(subAnnotation, retVal);
        }
    }
}

