/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;

public final class JobStatus
extends ImageHyperlink {
    private int numJobs = Integer.MIN_VALUE;
    private boolean numJobsSet = false;

    public JobStatus() {
        this.setRendererType("com.sun.webui.jsf.JobStatus");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.JobStatus";
    }

    @Override
    public String getIcon() {
        String icon = super.getIcon();
        if (icon == null) {
            icon = "MASTHEAD_STATUS_ICON";
        }
        return icon;
    }

    @Override
    public String getStyleClass() {
        String styleClass = super.getStyleClass();
        if (styleClass == null) {
            styleClass = "MASTHEAD_PROGRESS_LINK";
        }
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        return theme.getStyleClass(styleClass);
    }

    @Override
    public boolean isDisabled() {
        if (this.getNumJobs() == 0) {
            return true;
        }
        return super.isDisabled();
    }

    @Override
    public int getHeight() {
        return 17;
    }

    @Override
    public int getWidth() {
        return 17;
    }

    @Override
    public int getBorder() {
        return 0;
    }

    @Override
    public String getAlign() {
        return "middle";
    }

    @Override
    public String getAlt() {
        String alt = super.getAlt();
        if (alt == null) {
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            alt = theme.getMessage("masthead.tasksRunningAltText");
        }
        return alt;
    }

    @Override
    public String getOnDblClick() {
        return super.getOnDblClick();
    }

    @Override
    public String getTextPosition() {
        return super.getTextPosition();
    }

    public int getNumJobs() {
        if (this.numJobsSet) {
            return this.numJobs;
        }
        ValueExpression vb = this.getValueExpression("numJobs");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 0;
    }

    public void setNumJobs(int newNumJobs) {
        this.numJobs = newNumJobs;
        this.numJobsSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.numJobs = (Integer)values[1];
        this.numJobsSet = (Boolean)values[2];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.numJobs, this.numJobsSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

