/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.tools.file;

public class StringParser {
    private String data;
    private int pos;
    private char current;

    public StringParser(String str) {
        if (str.length() == 0) {
            throw new RuntimeException("Empty string not allowed");
        }
        this.data = str;
        this.pos = 0;
        this.current = str.charAt(this.pos);
    }

    private void setPos(int newPos) {
        if (newPos < this.data.length()) {
            this.pos = newPos;
            this.current = this.data.charAt(newPos);
        }
    }

    private boolean next() {
        if (this.data.length() > this.pos) {
            this.setPos(this.pos + 1);
            return true;
        }
        return false;
    }

    public boolean skipToString(String str) {
        int index = this.data.indexOf(str);
        if (index >= 0) {
            this.setPos(index);
            return true;
        }
        return false;
    }

    public boolean skipString(String str) {
        String cstr = this.data.substring(this.pos, this.pos + str.length());
        if (cstr.equals(str)) {
            this.setPos(this.pos + str.length());
            return true;
        }
        return false;
    }

    public boolean skipWhitespace() {
        boolean hasSkipped = false;
        while (Character.isWhitespace(this.current)) {
            hasSkipped = true;
            if (this.next()) continue;
            break;
        }
        return hasSkipped;
    }

    public String parseInt() {
        int first = this.pos;
        boolean atStart = true;
        while (this.current >= '0' && this.current <= '9') {
            atStart = false;
            if (this.next()) continue;
        }
        if (atStart) {
            return null;
        }
        return this.data.substring(first, this.pos);
    }
}

