/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class IntegerConverter
extends NumberConverter<Integer> {
    @Override
    public boolean supports(Class<Integer> rawType, Annotation[] annotations) {
        return Integer.class.equals(rawType) || Integer.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Integer> convert(String value, Class<Integer> rawType, Annotation[] annotations, Locale locale) {
        Integer defaultValue = Integer.TYPE.equals(rawType) ? Integer.valueOf(0) : null;
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(Number::intValue).orElse(defaultValue));
        }
        catch (ParseException e) {
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

