/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.protocol;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.common.handlers.ClientIDHandler;
import com.sun.messaging.jmq.jmsserver.common.handlers.FlowHandler;
import com.sun.messaging.jmq.jmsserver.common.handlers.SessionHandler;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.AckHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ConsumerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ProducerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.QBrowseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.RedeliverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.protocol.Protocol;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MaxConsecutiveRollbackException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ProtocolImpl
implements Protocol {
    private static boolean DEBUG = false;
    PacketRouter pr = null;
    private DestinationList DL = Globals.getDestinationList();
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();

    public ProtocolImpl(PacketRouter router) {
        this.pr = router;
    }

    @Override
    public boolean getDEBUG() {
        return DEBUG;
    }

    @Override
    public void hello() {
    }

    @Override
    public void authenticate(String username, String password) throws BrokerException {
    }

    @Override
    public void goodbye() {
    }

    @Override
    public Hashtable getLicense() {
        return new Hashtable();
    }

    @Override
    public Hashtable getInfo(boolean cluster) {
        return new Hashtable();
    }

    @Override
    public void ping() {
    }

    @Override
    public void flowPaused(int size) {
        throw new UnsupportedOperationException("flow paused is not supported by the client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(IMQConnection con, TransactionUID tid, boolean validate, int ackType, Throwable exception, String deadComment, int deliverCnt, SysMessageID[] ids, ConsumerUID[] cids) throws BrokerException, IOException {
        block16: {
            if (DEBUG) {
                this.logger.log(8, "ProtocolImpl.ACKNOWLEDGE:TID=" + String.valueOf(tid) + ", ackType=" + ackType + ", ids=" + Arrays.toString(ids) + ", cids=" + Arrays.toString(cids) + ", validate=" + validate + ", deadComment=" + deadComment + ", deliverCnt=" + deliverCnt + ", exception=" + String.valueOf(exception));
            }
            TransactionList[] tls = DestinationList.getTransactionList(con.getPartitionedStore());
            TransactionList tl = tls[0];
            AckHandler handler = (AckHandler)this.pr.getHandler(24);
            ArrayList cleanList = new ArrayList();
            try {
                block17: {
                    block19: {
                        block18: {
                            if (!validate) break block17;
                            if (ackType == 2) break block18;
                            if (ackType != 1) break block19;
                        }
                        throw new BrokerException("Can not use JMQValidate with an ackType of " + ackType, null, 400);
                    }
                    if (tid == null) {
                        throw new BrokerException("Can not use JMQValidate with no tid", null, 400);
                    }
                    if (!handler.validateMessages(tl, tid, ids, cids)) {
                        throw new BrokerException("Acknowledgement could not be found", null, 404);
                    }
                    break block16;
                }
                if (ackType == 2) {
                    handler.handleDeadMsgs(con, ids, cids, 0, exception, deadComment, deliverCnt, cleanList);
                } else if (ackType == 1) {
                    handler.handleUndeliverableMsgs(con, ids, cids, cleanList, deliverCnt, false);
                } else if (tid != null) {
                    handler.handleTransaction(tl, con, tid, ids, cids, deliverCnt);
                } else {
                    handler.handleAcks(con, ids, cids, true, cleanList);
                }
            }
            finally {
                handler.cleanUp(cleanList);
            }
        }
    }

    @Override
    public void setClientID(IMQConnection con, String clientID, String namespace, boolean share) throws BrokerException {
        ClientIDHandler handler = (ClientIDHandler)this.pr.getHandler(50);
        handler.setClientID(con, clientID, namespace, share);
    }

    @Override
    public Producer addProducer(Destination d, IMQConnection con, String uid, boolean acc) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.addProducer(d=" + String.valueOf(d) + ", uid=" + uid + ", acc=" + acc + ") on conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
        }
        if (acc) {
            this.checkAccessPermission(18, d, con);
        }
        ProducerHandler handler = (ProducerHandler)this.pr.getHandler(18);
        return handler.addProducer(d.getDestinationUID(), con, uid, false);
    }

    @Override
    public void removeProducer(ProducerUID uid, IMQConnection con, String suid) throws BrokerException {
        ProducerHandler handler = (ProducerHandler)this.pr.getHandler(18);
        handler.removeProducer(uid, false, con, suid);
    }

    @Override
    public void resumeFlow(IMQConnection con, int bufsize) {
        FlowHandler handler = (FlowHandler)this.pr.getHandler(52);
        handler.connectionFlow(con, bufsize);
    }

    @Override
    public void resumeFlow(Consumer con, int bufsize) {
        FlowHandler handler = (FlowHandler)this.pr.getHandler(52);
        handler.consumerFlow(con, bufsize);
    }

    @Override
    public ArrayList deliver(long cid, ArrayList ids) throws BrokerException, IOException {
        ArrayList<Packet> returnlist = new ArrayList<Packet>();
        for (SysMessageID id : ids) {
            PacketReference ref = DestinationList.get(null, id);
            if (ref == null) continue;
            Packet realp = ref.getPacket();
            if (ref.isInvalid()) continue;
            Packet p = new Packet(false);
            p.fill(realp);
            p.setConsumerID(cid);
            returnlist.add(p);
        }
        return returnlist;
    }

    @Override
    public ArrayList redeliver(TransactionUID tid, ConsumerUID[] cids, SysMessageID[] ids, boolean redeliver) throws BrokerException {
        return new ArrayList();
    }

    @Override
    public Session createSession(int ackType, IMQConnection con) throws BrokerException {
        Object obj = new Object();
        SessionHandler handler = (SessionHandler)this.pr.getHandler(68);
        return handler.createSession(ackType, obj.toString(), con, false);
    }

    @Override
    public void destroySession(SessionUID uid, IMQConnection con) throws BrokerException {
        SessionHandler handler = (SessionHandler)this.pr.getHandler(68);
        handler.closeSession(uid, con, false);
    }

    @Override
    public void pauseSession(SessionUID uid) throws BrokerException {
        Session ses = Session.getSession(uid);
        if (ses == null) {
            throw new BrokerException("No session for " + String.valueOf((Object)uid));
        }
        ses.pause("PROTOCOL");
    }

    @Override
    public void resumeSession(SessionUID uid) throws BrokerException {
        Session ses = Session.getSession(uid);
        if (ses == null) {
            throw new BrokerException("No session for " + String.valueOf((Object)uid));
        }
        ses.resume("PROTOCOL");
    }

    @Override
    public void pauseConnection(IMQConnection con) {
        con.stopConnection();
    }

    @Override
    public void resumeConnection(IMQConnection con) {
        con.startConnection();
    }

    @Override
    public ArrayList browseQueue(Destination d, String sstr, IMQConnection con, boolean acc) throws BrokerException, SelectorFormatException {
        if (acc) {
            this.checkAccessPermission(26, d, con);
        }
        QBrowseHandler handler = (QBrowseHandler)this.pr.getHandler(26);
        return handler.getQBrowseList(d, sstr);
    }

    @Override
    public Consumer createConsumer(Destination d, IMQConnection con, Session session, String selector, String clientid, String subscriptionName, boolean durable, boolean share, boolean jmsshare, boolean nolocal, int size, String creator_uid, boolean acc, boolean useFlowControl) throws BrokerException, SelectorFormatException, IOException {
        Consumer[] c;
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.createProducer(d=" + String.valueOf(d) + ", selector=" + selector + ", clientid=" + clientid + ", subName=" + subscriptionName + ", durable=" + durable + ", share=" + share + ", jmsshare=" + jmsshare + ", nolocal=" + nolocal + ", size=" + size + ", creator_uid=" + creator_uid + ", acc=" + acc + ", useFlowControl=" + useFlowControl + ") on session=" + String.valueOf(session) + "@" + session.hashCode() + ", conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
        }
        if (acc) {
            this.checkAccessPermission(14, d, con);
        }
        ConsumerHandler handler = (ConsumerHandler)this.pr.getHandler(14);
        String selectorstr = selector;
        if (selectorstr != null && selectorstr.trim().length() == 0) {
            selectorstr = null;
        }
        if (d.isTemporary()) {
            if (durable) {
                String emsg = this.br.getKString("B4438", String.valueOf(d.getDestinationUID()), subscriptionName);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg, 412);
            }
            if (share) {
                String emsg = this.br.getKString("B4439", String.valueOf(d.getDestinationUID()), subscriptionName);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg, 412);
            }
        }
        if ((c = handler.createConsumer(d.getDestinationUID(), con, session, selectorstr, clientid, subscriptionName, durable, share, jmsshare, nolocal, size, creator_uid, false, useFlowControl))[2] != null) {
            c[2].resume("Resuming from protocol");
        }
        if (c[1] != null) {
            c[1].resume("Resuming from protocol");
        }
        return c[0];
    }

    @Override
    public void unsubscribe(String durableName, String clientID, IMQConnection con) throws BrokerException {
        ConsumerHandler handler = (ConsumerHandler)this.pr.getHandler(14);
        handler.destroyConsumer(con, null, null, durableName, clientID, null, false, false, false);
    }

    @Override
    public void destroyConsumer(ConsumerUID uid, Session session, SysMessageID lastid, boolean lastidInTransaction, IMQConnection con) throws BrokerException {
        ConsumerHandler handler = (ConsumerHandler)this.pr.getHandler(14);
        handler.destroyConsumer(con, session, uid, null, null, lastid, lastidInTransaction, lastid == null, false);
    }

    @Override
    public void endTransaction(TransactionUID id, JMQXid xid, Integer xaFlags, IMQConnection con) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.END TRANSACTION:TID=" + String.valueOf(id) + ", XID=" + String.valueOf(xid) + ", xaFlags=" + TransactionState.xaFlagToString(xaFlags) + ", conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
        }
        TransactionHandler handler = (TransactionHandler)this.pr.getHandler(44);
        Object[] oo = TransactionList.getTransListAndState(id, con, false, false);
        if (oo == null) {
            throw new BrokerException("Unknown transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)), 404);
        }
        TransactionList tl = (TransactionList)oo[0];
        TransactionState ts = (TransactionState)oo[1];
        handler.doEnd(tl, 58, xid, xaFlags, ts, id);
    }

    @Override
    public TransactionUID startTransaction(JMQXid xid, Integer xaFlags, AutoRollbackType type, long lifetime, IMQConnection con) throws BrokerException {
        Object[] oo;
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.START TRANSACTION:XID=" + String.valueOf(xid) + ", xaFlags=" + TransactionState.xaFlagToString(xaFlags) + ", type=" + String.valueOf(type) + ", lifetime=" + lifetime + ", conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
        }
        List conlist = con.getTransactionListThreadSafe();
        TransactionHandler handler = (TransactionHandler)this.pr.getHandler(44);
        TransactionUID id = null;
        TransactionList tl = null;
        if (xaFlags == null || TransactionState.isFlagSet(0, xaFlags)) {
            id = new TransactionUID();
            TransactionList[] tls = DestinationList.getTransactionList(con.getPartitionedStore());
            tl = tls[0];
            if (tl == null) {
                throw new BrokerException("No transaction List for connection " + String.valueOf(con) + " to start new transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)));
            }
        } else if (xid != null) {
            oo = TransactionList.mapXidToTid(xid, con);
            if (oo == null) {
                throw new BrokerException("Unknown XID " + String.valueOf(xid), 404);
            }
            tl = (TransactionList)oo[0];
            id = (TransactionUID)oo[1];
        } else {
            throw new BrokerException("Invalid xid");
        }
        if (tl == null && (oo = TransactionList.getTransListAndState(id, con, false, false)) != null) {
            tl = (TransactionList)oo[0];
        }
        if (tl == null) {
            throw new BrokerException("No Transaction List found for connection " + String.valueOf(con) + " to start transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)));
        }
        Object o = new Object();
        handler.doStart(tl, id, conlist, con, type, xid, xid != null, lifetime, 0L, xaFlags, 44, false, o.toString());
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.STARTED TRANSACTION:TID=" + String.valueOf(id) + ", XID=" + String.valueOf(xid) + ", type=" + String.valueOf(type) + ", con=" + String.valueOf(con));
        }
        return id;
    }

    @Override
    public void commitTransaction(TransactionUID id, JMQXid xid, Integer xaFlags, IMQConnection con) throws BrokerException {
        Object[] oo;
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.COMMIT TRANSACTION:TID=" + String.valueOf(id) + ", XID=" + String.valueOf(xid) + ", xaFlags=" + TransactionState.xaFlagToString(xaFlags) + ", conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
        }
        List conlist = con.getTransactionListThreadSafe();
        TransactionHandler handler = (TransactionHandler)this.pr.getHandler(44);
        TransactionList tl = null;
        if (0L == id.longValue()) {
            if (xid == null) {
                throw new BrokerException("Unexpected TransactionUID  " + String.valueOf(id));
            }
            Object[] oo2 = TransactionList.mapXidToTid(xid, con);
            if (oo2 == null) {
                id = null;
            } else {
                tl = (TransactionList)oo2[0];
                id = (TransactionUID)oo2[1];
            }
            if (id == null) {
                throw new BrokerException("Unknown XID " + String.valueOf(xid), 404);
            }
        }
        TransactionState ts = null;
        if (tl == null && (oo = TransactionList.getTransListAndState(id, con, false, false)) != null) {
            tl = (TransactionList)oo[0];
            ts = (TransactionState)oo[1];
        }
        if (tl == null) {
            throw new BrokerException("Unknown transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)), 404);
        }
        if (ts == null && (ts = tl.retrieveState(id)) == null) {
            throw new BrokerException("Unknown transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)), 404);
        }
        if (!(xid == null || ts.getXid() != null && xid.equals((Object)ts.getXid()))) {
            throw new BrokerException("Transaction XID mismatch " + String.valueOf(xid) + ", expected " + String.valueOf(ts.getXid()) + " for transaction " + String.valueOf(id));
        }
        handler.doCommit(tl, id, xid, xaFlags, ts, conlist, false, con, null);
    }

    @Override
    public void prepareTransaction(TransactionUID id, IMQConnection con) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.PREPARE TRANSACTION:TID=" + String.valueOf(id) + ", conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
        }
        TransactionHandler handler = (TransactionHandler)this.pr.getHandler(44);
        Object[] oo = TransactionList.getTransListAndState(id, con, false, false);
        if (oo == null) {
            throw new BrokerException("Unknown transaction id " + String.valueOf(id), 404);
        }
        TransactionList tl = (TransactionList)oo[0];
        TransactionState ts = (TransactionState)oo[1];
        handler.doPrepare(tl, id, null, ts, 56, con);
    }

    @Override
    public void rollbackTransaction(TransactionUID id, JMQXid xid, IMQConnection con, boolean redeliver, boolean setRedeliver, int maxRollbacks, boolean dmqOnMaxRollbacks) throws BrokerException {
        MaxConsecutiveRollbackException bex;
        TransactionState ts;
        TransactionList tl;
        TransactionHandler handler;
        List conlist;
        block18: {
            Object[] oo;
            if (maxRollbacks <= 0) {
                boolean bl = dmqOnMaxRollbacks = Consumer.MSG_MAX_CONSECUTIVE_ROLLBACKS > 0;
            }
            if (DEBUG) {
                this.logger.log(8, "ProtocolImpl.ROLLBACK TRANSACTION:TID=" + String.valueOf(id) + ", XID=" + String.valueOf(xid) + ", conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "], redeliver=" + redeliver + ", setRedeliver=" + setRedeliver);
            }
            conlist = con.getTransactionListThreadSafe();
            handler = (TransactionHandler)this.pr.getHandler(44);
            tl = null;
            if (0L == id.longValue()) {
                if (xid == null) {
                    throw new BrokerException("Unexpected TransactionUID  " + String.valueOf(id));
                }
                Object[] oo2 = TransactionList.mapXidToTid(xid, con);
                if (oo2 == null) {
                    id = null;
                } else {
                    tl = (TransactionList)oo2[0];
                    id = (TransactionUID)oo2[1];
                }
                if (id == null) {
                    throw new BrokerException("Unknown XID " + String.valueOf(xid), 404);
                }
            }
            ts = null;
            if (tl == null && (oo = TransactionList.getTransListAndState(id, con, false, false)) != null) {
                tl = (TransactionList)oo[0];
                ts = (TransactionState)oo[1];
            }
            if (tl == null) {
                throw new BrokerException("Unknown transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)), 404);
            }
            if (ts == null && (ts = tl.retrieveState(id)) == null) {
                throw new BrokerException("Unknown transaction " + String.valueOf(id) + (String)(xid == null ? "" : " XID=" + String.valueOf(xid)), 404);
            }
            if (!(xid == null || ts.getXid() != null && xid.equals((Object)ts.getXid()))) {
                throw new BrokerException("Transaction XID mismatch " + String.valueOf(xid) + ", expected " + String.valueOf(ts.getXid()) + " for transaction " + String.valueOf(id));
            }
            handler.preRollback(tl, id, xid, null, ts);
            bex = null;
            if (redeliver) {
                try {
                    handler.redeliverUnacked(tl, id, true, setRedeliver, false, maxRollbacks, dmqOnMaxRollbacks);
                }
                catch (MaxConsecutiveRollbackException e) {
                    bex = e;
                    if (dmqOnMaxRollbacks) break block18;
                    throw bex;
                }
            }
        }
        try {
            handler.doRollback(tl, id, xid, null, ts, conlist, con, RollbackReason.APPLICATION);
        }
        catch (BrokerException e) {
            if (bex != null) {
                throw bex;
            }
            throw e;
        }
        if (bex != null) {
            throw bex;
        }
    }

    @Override
    public JMQXid[] recoverTransaction(TransactionUID id) {
        if (DEBUG) {
            this.logger.log(8, "ProtocolImpl.RECOVER TRANSACTION:TID=" + String.valueOf(id));
        }
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = null;
        TransactionState ts = null;
        LinkedHashMap<TransactionList, Vector> map = new LinkedHashMap<TransactionList, Vector>();
        Vector v = null;
        for (int i = 0; i < tls.length; ++i) {
            tl = tls[i];
            if (id == null) {
                v = tl.getTransactions(5);
                map.put(tl, v);
                continue;
            }
            ts = tl.retrieveState(id);
            if (ts == null || ts.getState() != 5) continue;
            v = new Vector();
            v.add(id);
            map.put(tl, v);
            break;
        }
        ArrayList<JMQXid> xids = new ArrayList<JMQXid>();
        for (Map.Entry pair : map.entrySet()) {
            tl = (TransactionList)pair.getKey();
            v = (Vector)pair.getValue();
            for (TransactionUID tuid : v) {
                TransactionState _ts = tl.retrieveState(tuid);
                if (_ts == null) continue;
                JMQXid _xid = _ts.getXid();
                xids.add(_xid);
            }
        }
        return xids.toArray(new JMQXid[xids.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap verifyDestination(String destination, int type, String selectorstr) throws BrokerException, IOException {
        HashMap<String, Constable> returnmap = new HashMap<String, Constable>();
        try {
            if (selectorstr != null) {
                Selector.compile((String)selectorstr);
            }
        }
        catch (SelectorFormatException ex) {
            returnmap.put("JMQStatus", Integer.valueOf(400));
            return returnmap;
        }
        Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)type));
        Destination d = ds[0];
        if (d == null) {
            returnmap.put("JMQCanCreate", Boolean.valueOf(DestinationList.canAutoCreate(DestType.isQueue((int)type))));
            returnmap.put("JMQStatus", Integer.valueOf(404));
            return returnmap;
        }
        returnmap.put("JMQDestType", Integer.valueOf(d.getType()));
        returnmap.put("JMQStatus", Integer.valueOf(200));
        return returnmap;
    }

    @Override
    public Map verifyTransaction(TransactionUID tuid) throws BrokerException {
        Object[] oo = TransactionList.getTransListAndState(tuid, null, true, false);
        if (oo == null) {
            return null;
        }
        TransactionList translist = (TransactionList)oo[0];
        TransactionState ts = (TransactionState)oo[1];
        int realstate = ts.getState();
        if (realstate != 5) {
            return null;
        }
        return translist.getTransactionMap(tuid, true);
    }

    @Override
    public void redeliver(ConsumerUID[] ids, SysMessageID[] sysids, IMQConnection con, TransactionUID tid, boolean redeliver) throws BrokerException, IOException {
        RedeliverHandler handler = (RedeliverHandler)this.pr.getHandler(32);
        handler.redeliver(ids, sysids, con, tid, redeliver);
    }

    @Override
    public void processMessage(IMQConnection con, Packet msg) throws BrokerException, SelectorFormatException, IOException {
        DataHandler handler = (DataHandler)this.pr.getHandler(6);
        Destination d = null;
        PacketReference ref = null;
        Set s = null;
        boolean route = false;
        boolean isadmin = con.isAdminConnection();
        ArrayList<MessageDeliveryTimeInfo> deliveryDelayReadyList = new ArrayList<MessageDeliveryTimeInfo>();
        try {
            boolean transacted;
            Destination[] ds = DestinationList.getDestination(con.getPartitionedStore(), msg.getDestination(), msg.getIsQueue());
            d = ds[0];
            if (d == null) {
                throw new BrokerException("Unknown Destination:" + msg.getDestination());
            }
            Producer pausedProducer = handler.checkFlow(msg, con);
            boolean bl = transacted = msg.getTransactionID() != 0L;
            if (DEBUG) {
                this.logger.log(8, "ProtocolImpl.PROCESS MESSAGE[" + String.valueOf(msg) + "]TID=" + msg.getTransactionID() + " to destination " + String.valueOf(d) + ", on conn=@" + con.hashCode() + "[" + String.valueOf((Object)con.getConnectionUID()) + ", " + String.valueOf(con) + "]");
            }
            ref = handler.createReference(msg, d.getDestinationUID(), con, isadmin);
            route = handler.queueMessage(d, ref, transacted);
            s = handler.routeMessage(con.getPartitionedStore(), transacted, ref, route, d, deliveryDelayReadyList);
            handler.pauseProducer(d, pausedProducer, con);
        }
        catch (BrokerException ex) {
            int status = ex.getStatusCode();
            if (status == 500 && ref != null && d != null) {
                handler.cleanupOnError(d, ref);
            }
            throw ex;
        }
        if (route && s != null) {
            try {
                handler.forwardMessage(d, ref, s);
            }
            catch (Exception e) {
                Object[] emsg = new Object[]{ref, d.getDestinationUID(), s};
                this.logger.logStack(16, Globals.getBrokerResources().getKString("B4404", emsg), (Throwable)e);
            }
        }
        if (deliveryDelayReadyList.size() > 0) {
            MessageDeliveryTimeInfo di2 = null;
            for (MessageDeliveryTimeInfo di2 : deliveryDelayReadyList) {
                di2.setDeliveryReady();
            }
        }
    }

    @Override
    public Destination createDestination(String dname, int dtype, IMQConnection con, boolean acc) throws BrokerException, IOException {
        if (acc) {
            this.checkAccessPermission(34, dname, dtype, con);
        }
        if (DestType.isTemporary((int)dtype)) {
            boolean storeTemps = con.getConnectionUID().getCanReconnect();
            long reconnectTime = con.getReconnectInterval();
            Destination[] ds = DestinationList.createTempDestination(con.getPartitionedStore(), dname, dtype, con.getConnectionUID(), storeTemps, reconnectTime);
            Destination d = ds[0];
            if (con.getConnectionUID().equals((Object)d.getConnectionUID())) {
                con.attachTempDestination(d.getDestinationUID());
            }
            return d;
        }
        Destination[] ds = DestinationList.getDestination(con.getPartitionedStore(), dname, dtype, true, !con.isAdminConnection());
        return ds[0];
    }

    @Override
    public void destroyDestination(DestinationUID duid) throws BrokerException, IOException {
        DestinationList.removeDestination(null, duid, true, "request from protocol");
    }

    void checkAccessPermission(int pktType, Destination d, IMQConnection con) throws BrokerException {
        this.checkAccessPermission(pktType, d.getDestinationName(), d.getType(), con);
    }

    void checkAccessPermission(int pktType, String dname, int dtype, IMQConnection con) throws BrokerException {
        String op = PacketType.mapOperation((int)pktType);
        if (op == null) {
            return;
        }
        PacketHandler handler = this.pr.getHandler(pktType);
        try {
            handler.checkPermission(pktType, op, dname, dtype, con);
        }
        catch (AccessControlException e) {
            throw new BrokerException(e.getMessage(), e, 403);
        }
    }
}

