/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.rmic.tools.asm.ArrayData;
import org.glassfish.rmic.tools.asm.CatchData;
import org.glassfish.rmic.tools.asm.ConstantPool;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.asm.LocalVariable;
import org.glassfish.rmic.tools.asm.SwitchData;
import org.glassfish.rmic.tools.asm.TryData;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.MemberDefinition;

public class Instruction
implements Constants {
    long where;
    int pc;
    int opc;
    Object value;
    Instruction next;
    boolean flagCondInverted;
    boolean flagNoCovered = false;
    public static final double SWITCHRATIO;

    public Instruction(long where, int opc, Object value, boolean flagCondInverted) {
        this.where = where;
        this.opc = opc;
        this.value = value;
        this.flagCondInverted = flagCondInverted;
    }

    public Instruction(boolean flagNoCovered, long where, int opc, Object value) {
        this.where = where;
        this.opc = opc;
        this.value = value;
        this.flagNoCovered = flagNoCovered;
    }

    public Instruction(long where, int opc, boolean flagNoCovered) {
        this.where = where;
        this.opc = opc;
        this.flagNoCovered = flagNoCovered;
    }

    public Instruction(long where, int opc, Object value) {
        this.where = where;
        this.opc = opc;
        this.value = value;
    }

    public int getOpcode() {
        return this.pc;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    void optimize(Environment env) {
        switch (this.opc) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (!(this.value instanceof LocalVariable) || env.debug_vars()) break;
                this.value = ((LocalVariable)this.value).slot;
                break;
            }
            case 167: {
                Label lbl = (Label)this.value;
                lbl = lbl.getDestination();
                this.value = lbl;
                if (lbl == this.next) {
                    this.opc = -2;
                    break;
                }
                if (lbl.next == null || !env.opt()) break;
                switch (lbl.next.opc) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        this.opc = lbl.next.opc;
                        this.value = lbl.next.value;
                    }
                }
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.value = ((Label)this.value).getDestination();
                if (this.value == this.next) {
                    this.opc = 87;
                    break;
                }
                if (this.next.opc != 167 || this.value != this.next.next) break;
                switch (this.opc) {
                    case 153: {
                        this.opc = 154;
                        break;
                    }
                    case 154: {
                        this.opc = 153;
                        break;
                    }
                    case 155: {
                        this.opc = 156;
                        break;
                    }
                    case 158: {
                        this.opc = 157;
                        break;
                    }
                    case 157: {
                        this.opc = 158;
                        break;
                    }
                    case 156: {
                        this.opc = 155;
                        break;
                    }
                    case 198: {
                        this.opc = 199;
                        break;
                    }
                    case 199: {
                        this.opc = 198;
                    }
                }
                this.flagCondInverted = !this.flagCondInverted;
                this.value = this.next.value;
                this.next.opc = -2;
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.value = ((Label)this.value).getDestination();
                if (this.value == this.next) {
                    this.opc = 88;
                    break;
                }
                if (this.next.opc != 167 || this.value != this.next.next) break;
                switch (this.opc) {
                    case 165: {
                        this.opc = 166;
                        break;
                    }
                    case 166: {
                        this.opc = 165;
                        break;
                    }
                    case 159: {
                        this.opc = 160;
                        break;
                    }
                    case 160: {
                        this.opc = 159;
                        break;
                    }
                    case 163: {
                        this.opc = 164;
                        break;
                    }
                    case 162: {
                        this.opc = 161;
                        break;
                    }
                    case 161: {
                        this.opc = 162;
                        break;
                    }
                    case 164: {
                        this.opc = 163;
                    }
                }
                this.flagCondInverted = !this.flagCondInverted;
                this.value = this.next.value;
                this.next.opc = -2;
                break;
            }
            case 170: 
            case 171: {
                SwitchData sw = (SwitchData)this.value;
                sw.defaultLabel = sw.defaultLabel.getDestination();
                Enumeration<Integer> e = sw.tab.keys();
                while (e.hasMoreElements()) {
                    Integer k = e.nextElement();
                    Label lbl = sw.tab.get(k);
                    sw.tab.put(k, lbl.getDestination());
                }
                long range = (long)sw.maxValue - (long)sw.minValue + 1L;
                long tableSize = 4L + range;
                long entries = sw.tab.size();
                long lookupSize = 3L + 2L * entries;
                if ((double)tableSize <= (double)lookupSize * SWITCHRATIO) {
                    this.opc = 170;
                    break;
                }
                this.opc = 171;
                break;
            }
        }
    }

    void collect(ConstantPool tab) {
        switch (this.opc) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (this.value instanceof LocalVariable) {
                    MemberDefinition field = ((LocalVariable)this.value).field;
                    tab.put(field.getName().toString());
                    tab.put(field.getType().getTypeSignature());
                }
                return;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 192: 
            case 193: {
                tab.put(this.value);
                return;
            }
            case 189: {
                tab.put(this.value);
                return;
            }
            case 197: {
                tab.put(((ArrayData)this.value).type);
                return;
            }
            case 18: 
            case 19: {
                if (this.value instanceof Integer) {
                    int v = (Integer)this.value;
                    if (v >= -1 && v <= 5) {
                        this.opc = 3 + v;
                        return;
                    }
                    if (v >= -128 && v < 128) {
                        this.opc = 16;
                        return;
                    }
                    if (v >= Short.MIN_VALUE && v < 32768) {
                        this.opc = 17;
                        return;
                    }
                } else if (this.value instanceof Float) {
                    float v = ((Float)this.value).floatValue();
                    if (v == 0.0f) {
                        if (Float.floatToIntBits(v) == 0) {
                            this.opc = 11;
                            return;
                        }
                    } else {
                        if (v == 1.0f) {
                            this.opc = 12;
                            return;
                        }
                        if (v == 2.0f) {
                            this.opc = 13;
                            return;
                        }
                    }
                }
                tab.put(this.value);
                return;
            }
            case 20: {
                if (this.value instanceof Long) {
                    long v = (Long)this.value;
                    if (v == 0L) {
                        this.opc = 9;
                        return;
                    }
                    if (v == 1L) {
                        this.opc = 10;
                        return;
                    }
                } else if (this.value instanceof Double) {
                    double v = (Double)this.value;
                    if (v == 0.0) {
                        if (Double.doubleToLongBits(v) == 0L) {
                            this.opc = 14;
                            return;
                        }
                    } else if (v == 1.0) {
                        this.opc = 15;
                        return;
                    }
                }
                tab.put(this.value);
                return;
            }
            case -3: {
                Enumeration<CatchData> e = ((TryData)this.value).catches.elements();
                while (e.hasMoreElements()) {
                    CatchData cd = e.nextElement();
                    if (cd.getType() == null) continue;
                    tab.put(cd.getType());
                }
                return;
            }
            case 0: {
                if (this.value != null && this.value instanceof ClassDeclaration) {
                    tab.put(this.value);
                }
                return;
            }
        }
    }

    int balance() {
        switch (this.opc) {
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 47: 
            case 49: 
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 132: 
            case 134: 
            case 138: 
            case 139: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 188: 
            case 189: 
            case 190: 
            case 192: 
            case 193: 
            case 200: 
            case 201: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 89: 
            case 90: 
            case 91: 
            case 133: 
            case 135: 
            case 140: 
            case 141: 
            case 187: {
                return 1;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 87: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 137: 
            case 142: 
            case 144: 
            case 149: 
            case 150: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return -1;
            }
            case 55: 
            case 57: 
            case 88: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: 
            case 129: 
            case 131: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                return -2;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 148: 
            case 151: 
            case 152: {
                return -3;
            }
            case 80: 
            case 82: {
                return -4;
            }
            case 197: {
                return 1 - ((ArrayData)this.value).nargs;
            }
            case 180: {
                return ((MemberDefinition)this.value).getType().stackSize() - 1;
            }
            case 181: {
                return -1 - ((MemberDefinition)this.value).getType().stackSize();
            }
            case 178: {
                return ((MemberDefinition)this.value).getType().stackSize();
            }
            case 179: {
                return -((MemberDefinition)this.value).getType().stackSize();
            }
            case 182: 
            case 183: 
            case 185: {
                return ((MemberDefinition)this.value).getType().getReturnType().stackSize() - (((MemberDefinition)this.value).getType().stackSize() + 1);
            }
            case 184: {
                return ((MemberDefinition)this.value).getType().getReturnType().stackSize() - ((MemberDefinition)this.value).getType().stackSize();
            }
        }
        throw new CompilerError("invalid opcode: " + this.toString());
    }

    int size(ConstantPool tab) {
        switch (this.opc) {
            case -3: 
            case -2: 
            case -1: {
                return 0;
            }
            case 16: 
            case 188: {
                return 2;
            }
            case 17: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return 3;
            }
            case 18: 
            case 19: {
                if (tab.index(this.value) < 256) {
                    this.opc = 18;
                    return 2;
                }
                this.opc = 19;
                return 3;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int v = ((Number)this.value).intValue();
                if (v < 4) {
                    if (v < 0) {
                        throw new CompilerError("invalid slot: " + this.toString() + "\nThis error possibly resulted from poorly constructed class paths.");
                    }
                    this.opc = 26 + (this.opc - 21) * 4 + v;
                    return 1;
                }
                if (v <= 255) {
                    return 2;
                }
                this.opc += 256;
                return 4;
            }
            case 132: {
                int register = ((int[])this.value)[0];
                int increment = ((int[])this.value)[1];
                if (register < 0) {
                    throw new CompilerError("invalid slot: " + this.toString());
                }
                if (register <= 255 && (byte)increment == increment) {
                    return 3;
                }
                this.opc += 256;
                return 6;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                int v;
                int n = v = this.value instanceof Number ? ((Number)this.value).intValue() : ((LocalVariable)this.value).slot;
                if (v < 4) {
                    if (v < 0) {
                        throw new CompilerError("invalid slot: " + this.toString());
                    }
                    this.opc = 59 + (this.opc - 54) * 4 + v;
                    return 1;
                }
                if (v <= 255) {
                    return 2;
                }
                this.opc += 256;
                return 4;
            }
            case 169: {
                int v = ((Number)this.value).intValue();
                if (v <= 255) {
                    if (v < 0) {
                        throw new CompilerError("invalid slot: " + this.toString());
                    }
                    return 2;
                }
                this.opc += 256;
                return 4;
            }
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return 3;
            }
            case 197: {
                return 4;
            }
            case 185: 
            case 200: 
            case 201: {
                return 5;
            }
            case 170: {
                SwitchData sw = (SwitchData)this.value;
                int n = 1;
                while ((this.pc + n) % 4 != 0) {
                    ++n;
                }
                return n + 16 + (sw.maxValue - sw.minValue) * 4;
            }
            case 171: {
                SwitchData sw = (SwitchData)this.value;
                int n = 1;
                while ((this.pc + n) % 4 != 0) {
                    ++n;
                }
                return n + 8 + sw.tab.size() * 8;
            }
            case 0: {
                if (this.value != null && !(this.value instanceof Integer)) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    void write(DataOutputStream out, ConstantPool tab) throws IOException {
        switch (this.opc) {
            case -3: 
            case -2: 
            case -1: {
                break;
            }
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 169: 
            case 188: {
                out.writeByte(this.opc);
                out.writeByte(((Number)this.value).intValue());
                break;
            }
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 425: {
                out.writeByte(196);
                out.writeByte(this.opc - 256);
                out.writeShort(((Number)this.value).intValue());
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                out.writeByte(this.opc);
                out.writeByte(this.value instanceof Number ? ((Number)this.value).intValue() : ((LocalVariable)this.value).slot);
                break;
            }
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                out.writeByte(196);
                out.writeByte(this.opc - 256);
                out.writeShort(this.value instanceof Number ? ((Number)this.value).intValue() : ((LocalVariable)this.value).slot);
                break;
            }
            case 17: {
                out.writeByte(this.opc);
                out.writeShort(((Number)this.value).intValue());
                break;
            }
            case 18: {
                out.writeByte(this.opc);
                out.writeByte(tab.index(this.value));
                break;
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 192: 
            case 193: {
                out.writeByte(this.opc);
                out.writeShort(tab.index(this.value));
                break;
            }
            case 132: {
                out.writeByte(this.opc);
                out.writeByte(((int[])this.value)[0]);
                out.writeByte(((int[])this.value)[1]);
                break;
            }
            case 388: {
                out.writeByte(196);
                out.writeByte(this.opc - 256);
                out.writeShort(((int[])this.value)[0]);
                out.writeShort(((int[])this.value)[1]);
                break;
            }
            case 189: {
                out.writeByte(this.opc);
                out.writeShort(tab.index(this.value));
                break;
            }
            case 197: {
                out.writeByte(this.opc);
                out.writeShort(tab.index(((ArrayData)this.value).type));
                out.writeByte(((ArrayData)this.value).nargs);
                break;
            }
            case 185: {
                out.writeByte(this.opc);
                out.writeShort(tab.index(this.value));
                out.writeByte(((MemberDefinition)this.value).getType().stackSize() + 1);
                out.writeByte(0);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                out.writeByte(this.opc);
                out.writeShort(((Instruction)this.value).pc - this.pc);
                break;
            }
            case 200: 
            case 201: {
                out.writeByte(this.opc);
                out.writeLong(((Instruction)this.value).pc - this.pc);
                break;
            }
            case 170: {
                SwitchData sw = (SwitchData)this.value;
                out.writeByte(this.opc);
                int n = 1;
                while ((this.pc + n) % 4 != 0) {
                    out.writeByte(0);
                    ++n;
                }
                out.writeInt(sw.defaultLabel.pc - this.pc);
                out.writeInt(sw.minValue);
                out.writeInt(sw.maxValue);
                for (n = sw.minValue; n <= sw.maxValue; ++n) {
                    Label lbl = sw.get(n);
                    int target_pc = lbl != null ? lbl.pc : sw.defaultLabel.pc;
                    out.writeInt(target_pc - this.pc);
                }
                break;
            }
            case 171: {
                SwitchData sw = (SwitchData)this.value;
                out.writeByte(this.opc);
                int n = this.pc + 1;
                while (n % 4 != 0) {
                    out.writeByte(0);
                    ++n;
                }
                out.writeInt(sw.defaultLabel.pc - this.pc);
                out.writeInt(sw.tab.size());
                Enumeration<Integer> e = sw.sortedKeys();
                while (e.hasMoreElements()) {
                    Integer v = e.nextElement();
                    out.writeInt(v);
                    out.writeInt(sw.get((Integer)v).pc - this.pc);
                }
                break;
            }
            case 0: {
                if (this.value != null) {
                    if (this.value instanceof Integer) {
                        out.writeByte((Integer)this.value);
                    } else {
                        out.writeShort(tab.index(this.value));
                    }
                    return;
                }
            }
            default: {
                out.writeByte(this.opc);
            }
        }
    }

    public String toString() {
        String prefix = (this.where >> 32) + ":\t";
        switch (this.opc) {
            case -3: {
                return prefix + "try " + ((TryData)this.value).getEndLabel().hashCode();
            }
            case -2: {
                return prefix + "dead";
            }
            case 132: {
                int register = ((int[])this.value)[0];
                int increment = ((int[])this.value)[1];
                return prefix + opcNames[this.opc] + " " + register + ", " + increment;
            }
        }
        if (this.value != null) {
            if (this.value instanceof Label) {
                return prefix + opcNames[this.opc] + " " + this.value.toString();
            }
            if (this.value instanceof Instruction) {
                return prefix + opcNames[this.opc] + " " + this.value.hashCode();
            }
            if (this.value instanceof String) {
                return prefix + opcNames[this.opc] + " \"" + this.value + "\"";
            }
            return prefix + opcNames[this.opc] + " " + this.value;
        }
        return prefix + opcNames[this.opc];
    }

    static {
        double ratio = 1.5;
        String valStr = System.getProperty("javac.switchratio");
        if (valStr != null) {
            try {
                double temp = Double.valueOf(valStr);
                if (!Double.isNaN(temp) && !(temp < 0.0)) {
                    ratio = temp;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SWITCHRATIO = ratio;
    }
}

