/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class BasicNoPutResultSetImpl
implements NoPutResultSet {
    protected boolean isOpen;
    protected boolean finished;
    protected ExecRow currentRow;
    protected boolean isTopResultSet;
    private SQLWarning warnings;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    protected long startExecutionTime;
    protected long endExecutionTime;
    public long beginTime;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private StatementContext statementContext;
    public NoPutResultSet[] subqueryTrackingArray;
    ExecRow compactRow;
    protected final Activation activation;
    private final boolean statisticsTimingOn;
    ResultDescription resultDescription;
    private transient TransactionController tc;
    private int[] baseColumnMap;

    BasicNoPutResultSetImpl(ResultDescription resultDescription, Activation activation, double d, double d2) {
        this.activation = activation;
        this.statisticsTimingOn = this.getLanguageConnectionContext().getStatisticsTiming();
        if (this.statisticsTimingOn) {
            this.beginTime = this.startExecutionTime = this.getCurrentTimeMillis();
        }
        this.resultDescription = resultDescription;
        this.optimizerEstimatedRowCount = d;
        this.optimizerEstimatedCost = d2;
    }

    protected final void recordConstructorTime() {
        if (this.statisticsTimingOn) {
            this.constructorTime = this.getElapsedMillis(this.beginTime);
        }
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    protected final boolean isXplainOnlyMode() {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        return languageConnectionContext.getRunTimeStatisticsMode() && languageConnectionContext.getXplainOnlyMode();
    }

    @Override
    public void reopenCore() throws StandardException {
        this.close();
        this.openCore();
    }

    @Override
    public abstract ExecRow getNextRowCore() throws StandardException;

    @Override
    public int getPointOfAttachment() {
        return -1;
    }

    @Override
    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    @Override
    public int getScanIsolationLevel() {
        return 0;
    }

    @Override
    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    @Override
    public boolean requiresRelocking() {
        return false;
    }

    @Override
    public final void open() throws StandardException {
        this.finished = false;
        this.attachStatementContext();
        try {
            this.openCore();
        }
        catch (StandardException standardException) {
            this.activation.checkStatementValidity();
            throw standardException;
        }
        this.activation.checkStatementValidity();
    }

    @Override
    public ExecRow getAbsoluteRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "absolute");
        }
        this.attachStatementContext();
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "relative");
        }
        this.attachStatementContext();
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        return null;
    }

    @Override
    public boolean checkRowPosition(int n) throws StandardException {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        this.attachStatementContext();
        return null;
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "previous");
        }
        this.attachStatementContext();
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "last");
        }
        this.attachStatementContext();
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "last");
        }
        return null;
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public final long modifiedRowCount() {
        return 0L;
    }

    @Override
    public void cleanUp() throws StandardException {
        if (this.isOpen) {
            this.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    protected final void finishAndRTS() throws StandardException {
        if (!this.finished) {
            if (!this.isClosed()) {
                this.close();
            }
            this.finished = true;
            if (this.isTopResultSet && this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    @Override
    public long getExecuteTime() {
        return this.getTimeSpent(1);
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.startExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.startExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int n) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n];
        }
        return this.subqueryTrackingArray;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    protected final long getElapsedMillis(long l) {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis() - l;
        }
        return 0L;
    }

    protected final String dumpTimeStats(String string, String string2) {
        return string + MessageService.getTextMessage("42Z30.U", new Object[0]) + " " + this.getTimeSpent(0) + "\n" + string + MessageService.getTextMessage("42Z31.U", new Object[0]) + " " + this.getTimeSpent(1) + "\n" + string + MessageService.getTextMessage("42Z32.U", new Object[0]) + "\n" + string2 + MessageService.getTextMessage("42Z33.U", new Object[0]) + " " + this.constructorTime + "\n" + string2 + MessageService.getTextMessage("42Z34.U", new Object[0]) + " " + this.openTime + "\n" + string2 + MessageService.getTextMessage("42Z35.U", new Object[0]) + " " + this.nextTime + "\n" + string2 + MessageService.getTextMessage("42Z36.U", new Object[0]) + " " + this.closeTime;
    }

    protected void attachStatementContext() throws StandardException {
        if (this.isTopResultSet) {
            if (this.statementContext == null || !this.statementContext.onStack()) {
                this.statementContext = this.getLanguageConnectionContext().getStatementContext();
            }
            this.statementContext.setTopResultSet(this, this.subqueryTrackingArray);
            if (this.subqueryTrackingArray == null) {
                this.subqueryTrackingArray = this.statementContext.getSubqueryTrackingArray();
            }
            this.statementContext.setActivation(this.activation);
        }
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        return this.getActivation().getLanguageConnectionContext();
    }

    @Override
    public int resultSetNumber() {
        return 0;
    }

    final ExecutionFactory getExecutionFactory() {
        return this.activation.getExecutionFactory();
    }

    final TransactionController getTransactionController() {
        if (this.tc == null) {
            this.tc = this.getLanguageConnectionContext().getTransactionExecute();
        }
        return this.tc;
    }

    protected ExecRow getCompactRow(ExecRow execRow, FormatableBitSet formatableBitSet, boolean bl) throws StandardException {
        int n = execRow.nColumns();
        if (formatableBitSet == null) {
            this.compactRow = execRow;
            this.baseColumnMap = new int[n];
            for (int i = 0; i < this.baseColumnMap.length; ++i) {
                this.baseColumnMap[i] = i;
            }
        } else {
            int n2 = formatableBitSet.getNumBitsSet();
            this.baseColumnMap = new int[n2];
            if (this.compactRow == null) {
                ExecutionFactory executionFactory = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
                this.compactRow = bl ? executionFactory.getIndexableRow(n2) : executionFactory.getValueRow(n2);
            }
            int n3 = 0;
            int n4 = formatableBitSet.anySetBit();
            while (n4 != -1 && n4 < n) {
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(n4 + 1);
                if (dataValueDescriptor != null) {
                    this.compactRow.setColumn(n3 + 1, dataValueDescriptor);
                }
                this.baseColumnMap[n3] = n4;
                ++n3;
                n4 = formatableBitSet.anySetBit(n4);
            }
        }
        return this.compactRow;
    }

    protected ExecRow setCompactRow(ExecRow execRow, ExecRow execRow2) {
        ExecRow execRow3;
        if (this.baseColumnMap == null) {
            execRow3 = execRow;
        } else {
            execRow3 = execRow2;
            this.setCompatRow(execRow2, execRow.getRowArray());
        }
        return execRow3;
    }

    protected final void setCompatRow(ExecRow execRow, DataValueDescriptor[] dataValueDescriptorArray) {
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        int[] nArray = this.baseColumnMap;
        for (int i = 0; i < nArray.length; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[nArray[i]];
        }
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    public void checkCancellationFlag() throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        StatementContext statementContext = languageConnectionContext.getStatementContext();
        if (statementContext == null) {
            return;
        }
        InterruptStatus.throwIf(languageConnectionContext);
        if (statementContext.isCancelled()) {
            throw StandardException.newException("XCL52.S", new Object[0]);
        }
    }

    @Override
    public final void addWarning(SQLWarning sQLWarning) {
        ResultSet resultSet;
        if (this.isTopResultSet) {
            if (this.warnings == null) {
                this.warnings = sQLWarning;
            } else {
                this.warnings.setNextWarning(sQLWarning);
            }
            return;
        }
        if (this.activation != null && (resultSet = this.activation.getResultSet()) != null) {
            resultSet.addWarning(sQLWarning);
        }
    }

    @Override
    public final SQLWarning getWarnings() {
        SQLWarning sQLWarning = this.warnings;
        this.warnings = null;
        return sQLWarning;
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(element, string, this), this);
    }

    public static Element toXML(Element element, String string, ResultSet resultSet) throws Exception {
        Element element2 = element.getOwnerDocument().createElement(string);
        element2.setAttribute("type", BasicNoPutResultSetImpl.stripPackage(resultSet.getClass().getName()));
        element.appendChild(element2);
        return element2;
    }

    private static String stripPackage(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static Element childrenToXML(Element element, ResultSet resultSet) throws Exception {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        BasicNoPutResultSetImpl.findResultSetFields(arrayList, resultSet.getClass());
        Field[] fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        Arrays.sort(fieldArray, new FieldComparator());
        for (Field field : fieldArray) {
            Object object;
            Object object2 = field.get(resultSet);
            if (object2 == null) continue;
            if (field.getType().isArray()) {
                object = element.getOwnerDocument().createElement("array");
                object.setAttribute("arrayName", field.getName());
                String string = BasicNoPutResultSetImpl.stripPackage(field.getType().getComponentType().getName()) + "[]";
                object.setAttribute("type", string);
                element.appendChild((Node)object);
                int n = Array.getLength(object2);
                for (int i = 0; i < n; ++i) {
                    ResultSet resultSet2 = (ResultSet)Array.get(object2, i);
                    if (resultSet2 == null) continue;
                    Element element2 = resultSet2.toXML((Element)object, "cell");
                    element2.setAttribute("cellNumber", Integer.toString(i));
                }
                continue;
            }
            object = (ResultSet)object2;
            object.toXML(element, field.getName());
        }
        return element;
    }

    private static void findResultSetFields(ArrayList<Field> arrayList, final Class<?> clazz) throws Exception {
        Field[] fieldArray;
        if (clazz == null) {
            return;
        }
        for (Field field : fieldArray = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        })) {
            if (ResultSet.class.isAssignableFrom(field.getType())) {
                arrayList.add(field);
                continue;
            }
            if (!field.getType().isArray() || !ResultSet.class.isAssignableFrom(field.getType().getComponentType())) continue;
            arrayList.add(field);
        }
        BasicNoPutResultSetImpl.findResultSetFields(arrayList, clazz.getSuperclass());
    }

    public static final class FieldComparator
    implements Comparator<Field> {
        @Override
        public int compare(Field field, Field field2) {
            return field.getName().compareTo(field2.getName());
        }
    }
}

