/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.sniffer;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.GenericSniffer;
import org.glassfish.web.WarType;
import org.jvnet.hk2.annotations.Service;

@Service(name="web")
@Singleton
public class WebSniffer
extends GenericSniffer {
    @Inject
    WarType warType;
    @Inject
    ServiceLocator locator;
    private static final String[] containers = new String[]{"com.sun.enterprise.web.WebContainer"};
    private static final List<String> deploymentConfigurationPaths = WebSniffer.initDeploymentConfigurationPaths();
    private final String[] containerModuleNames = new String[]{"org.glassfish.main.web.glue", "org.glassfish.wasp.wasp"};

    public WebSniffer() {
        super("web", "WEB-INF/web.xml", null);
    }

    public String[] getURLPatterns() {
        return new String[]{"*.jsp", "*.jspx"};
    }

    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = (ArchiveType)this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        return DeploymentUtils.isArchiveOfType((ReadableArchive)context.getSource(), (ArchiveType)this.warType, (DeploymentContext)context, (ServiceLocator)this.locator);
    }

    public boolean handles(ReadableArchive location) {
        return DeploymentUtils.isArchiveOfType((ReadableArchive)location, (ArchiveType)this.warType, (ServiceLocator)this.locator);
    }

    public String[] getContainersNames() {
        return containers;
    }

    public boolean isUserVisible() {
        return true;
    }

    public boolean isJakartaEE() {
        return true;
    }

    private static List<String> initDeploymentConfigurationPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("WEB-INF/web.xml");
        result.add("WEB-INF/sun-web.xml");
        result.add("WEB-INF/glassfish-web.xml");
        result.add("WEB-INF/weblogic.xml");
        return result;
    }

    protected List<String> getDeploymentConfigurationPaths() {
        return deploymentConfigurationPaths;
    }

    public String[] getIncompatibleSnifferTypes() {
        return new String[]{"connector"};
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.equals((Object)this.warType);
    }

    protected String[] getContainerModuleNames() {
        return this.containerModuleNames;
    }
}

