/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigMapperProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

class EnumMapperProvider
implements ConfigMapperProvider {
    static final int PRIORITY = 10000;

    EnumMapperProvider() {
    }

    public Map<Class<?>, Function<Config, ?>> mappers() {
        return Map.of();
    }

    public <T> Optional<Function<Config, T>> mapper(Class<T> type) {
        if (!type.isEnum()) {
            return Optional.empty();
        }
        return Optional.of(this.enumMapper(type));
    }

    private <T> Function<Config, T> enumMapper(Class<Enum<?>> enumType) {
        return config -> {
            if (!config.hasValue() || !config.exists()) {
                throw MissingValueException.create(config.key());
            }
            if (!config.isLeaf()) {
                throw new ConfigMappingException(config.key(), enumType, "config node must be a leaf but is not");
            }
            String value = config.asString().get();
            String convertedValue = value.replace('-', '_');
            ArrayList<Enum> caseInsensitiveMatches = new ArrayList<Enum>();
            for (Enum candidate : (Enum[])enumType.getEnumConstants()) {
                if (candidate.name().equals(convertedValue) || candidate.name().equals(value)) {
                    return candidate;
                }
                if (!candidate.name().equalsIgnoreCase(value) && !candidate.name().equalsIgnoreCase(convertedValue)) continue;
                caseInsensitiveMatches.add(candidate);
            }
            if (caseInsensitiveMatches.size() == 1) {
                return caseInsensitiveMatches.get(0);
            }
            Object problem = caseInsensitiveMatches.size() == 0 ? "no match" : "ambiguous matches with " + caseInsensitiveMatches;
            throw new ConfigMappingException(config.key(), enumType, String.format("cannot map value '%s' to enum values %s: %s", value, Arrays.asList((Enum[])enumType.getEnumConstants()), problem));
        };
    }
}

