/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.SessionCloseListener;
import java.util.HashMap;
import java.util.Map;

public final class ServerConnectionSession
extends ConnectionSession {
    private Map<Integer, ChannelContext> channelId2context = new HashMap<Integer, ChannelContext>();
    private int channelCounter = 1;

    public ServerConnectionSession(Connection connection, SessionCloseListener<ServerConnectionSession> sessionCloseListener) {
        super(connection, sessionCloseListener);
        this.init();
    }

    @Override
    public void registerChannel(@NotNull ChannelContext context) {
        this.channelId2context.put(context.getChannelId(), context);
    }

    @Override
    @Nullable
    public ChannelContext findWSServiceContextByChannelId(int channelId) {
        return this.channelId2context.get(channelId);
    }

    public void deregisterChannel(int channelId) {
        this.channelId2context.remove(channelId);
    }

    @Override
    public void deregisterChannel(@NotNull ChannelContext context) {
        this.deregisterChannel(context.getChannelId());
    }

    @Override
    public void close() {
        super.close();
        this.channelId2context = null;
    }

    @Override
    public int getChannelsAmount() {
        return this.channelId2context.size();
    }

    public synchronized int getNextAvailChannelId() {
        return this.channelCounter++;
    }
}

